
#include "windows.h"
#include "WINUSER.H"
#include "global.h"
#define true 1
#define false 0
#include <commctrl.h>
#include "DDRAW_CTL.h"

//char szAbbr1[4], szAbbr2[4], szAbbr3[4], szAbbr4[4], szAbbr5[4], szAbbr6[4];


//------------------------------------------------------
void DSP1_Main_MSG(const int P_Long, const int P_Beep)
{
 
  int iLen;
  char *lpCTmp1;
  char szMain[_MAX_PATH*4];

  if (P_Beep)
      MessageBeep(MB_OK);

  if ( szMsgTxt[0] > ' ' || szMPG_ErrTxt[0] > ' ')
  {
    iLen = sprintf(szMain, "%s %s          \n", szMsgTxt, szMPG_ErrTxt);    
    
    if (DBGflag)
    {
        DBGout(szMain);
    }

    lpCTmp1 = strchr(szMain, '\n');
    if(lpCTmp1)
      if(*lpCTmp1)
         *lpCTmp1 = ' ';

    

    if (szMain[0] == '.')
       iMsgLife = 0;
    else
    if ((    MParse.Fault_Flag >= CRITICAL_ERROR_LEVEL
          && MParse.Fault_Flag <  97
          && szMain[0])
       //         || !MParse.SeqHdr_Found_Flag  
        || szMain[0] == '*')
    {
      MessageBox( NULL, szMain, "Mpg2Cut2 - PROBLEM",
                                   MB_OK | MB_SETFOREGROUND | MB_TOPMOST);
      iMsgLife = -1;
      szMain[0] = 0;
      szMsgTxt[0] = 0;
    }
    else
    {
      if (iLen > 54 && !P_Long)  // Let PF1=Long Msg
          iLen = 54;
      TextOut(hDC, 0, iMsgPosY, szMain, iLen);
      iMsgLife = 3 + (MParse.FastPlay_Flag<<1);
      UpdateWindow(hWnd_MAIN);
    }
    if (iMsgLen < iLen)
        iMsgLen = iLen;

    if (Frame_Number)
        szMsgTxt[0] = 0;
    szMPG_ErrTxt[0] = 0;

  }

}



//--------------------------------------------------------------
void DSP2_Main_SEL_INFO(int P_Force)
{
  int iLen; //, iTmp1;
  __int64 i64Tmp1;
  unsigned uSel_Secs, uSel_Min, uTot_Time ;
  char cTimeUnit;

  if (process.ToPadLoc <= 0)
  {
      File_Final = File_Limit-1;
      process.ToPadFile =                 File_Final ;
      //process.ToPadBlk  = (process.length[File_Final]/MPEG_SEARCH_BUFSZ) ;
      process.ToPadLoc  =  process.length[File_Final];
  }

  iSelMB  =  (int) ( (process.origin[process.ToPadFile] + process.ToPadLoc
                    - process.origin[process.FromFile]  - process.FromLoc )
                 //(process.ToPadBlk - process.FromBlk) * MPEG_SEARCH_BUFSZ
                   / 1048576 ) ;
  iInputTotMB =  (int) ((process.total + 524288) / 1048576 ) ;

  
  if (process.ToViewPTS > 0)
  {
      uSel_Secs = (process.ToViewPTS - process.FromPTS + 22000) / 45000 ;// +45000)/90000;
  }
  else
  {
    // Derive time estimate from file size and nominal byte rate
    i64Tmp1 =  process.ByteRateAvg[process.CurrFile];
    if (! i64Tmp1)
      i64Tmp1 = 1234567;
    uSel_Secs = (int)((__int64)(iSelMB) * 1048576 / i64Tmp1);
  }
  

  if (uSel_Secs > 59)
  {
     uSel_Min = uSel_Secs / 60;
     uSel_Secs -= (uSel_Min * 60);
     if (uSel_Min > 600) // Trap silly figures
        szTmp32[0] = 0;  // Suppress the time estimate
     else
        sprintf(szTmp32, "%dm%ds ", uSel_Min, uSel_Secs);
  }
  else
     sprintf(szTmp32, "%ds ", uSel_Secs);


  if (uEDL_TotTime > 120) // 2 mins 
  {
       uTot_Time = uEDL_TotTime / 60;  // 600; 
       cTimeUnit = 'm';
  }
  else
  {
       uTot_Time = uEDL_TotTime; //  / 10; 
       cTimeUnit = 's';
  }

  iLen = sprintf(szSelTxt, " %d clips %d%c   %dmb/%02d   +%s%dmb     ",
                   iEDL_ctr, uTot_Time, cTimeUnit,
                                            iEDL_TotMB, iInputTotMB,
                                                       szTmp32, iSelMB) ;

  if (MParse.SeqHdr_Found_Flag 
  &&  (!iMsgLife || P_Force))   // process.Preamble_Known)
      TextOut(hDC, iSelMsgX, iMsgPosY, szSelTxt, iLen);

  //process.trackPrev = SendMessage(hTrack, TBM_GETPOS, 0, 0);

}
 

/*
//--------------------------------------------------------------
void DSP365_TC_Edit(TC_HMSFR *xTC)

{

  if (xTC.hour > 00)
         sprintf(szHour, "%dh", xTC.hour);
      else
         szHour[0] = NULL;

      iLen = sprintf(szTemp, " %s %02dm %02ds %02df %c  A%c%s  Z%x   ",
              szHour, xTC.minute, xTC.sec, xTC.frameNum,
                      Coded_Pic_Abbr[MPEG_Pic_Type],
                      process.Delay_Sign[0], process.szDelay,
               rj_Audio_Code );

}
*/


// Adjust TC to Time Of Day, using creation time of FIRST file
// If files are not continous, then gives incorrect time of day

void Relative_TOD()
{

  ShowTC.frameNum  =  RelativeTC.frameNum;

  ShowTC.sec       =  RelativeTC.sec    + File_Greg[0].tm_sec;
  ShowTC.minute    =  RelativeTC.minute + File_Greg[0].tm_min;
  ShowTC.hour      =  RelativeTC.hour   + File_Greg[0].tm_hour;

  while (ShowTC.sec > 59)
  {
      ShowTC.sec = ShowTC.sec - 60;
      ShowTC.minute++;
  }

  while (ShowTC.minute > 59)
  {
      ShowTC.minute = ShowTC.minute - 60;
      ShowTC.hour++;
  }

  while (ShowTC.hour > 23)
  {
      ShowTC.hour = ShowTC.hour - 24;
  }

  if (ShowTC.hour < 12)
      strcpy(ShowTC_AM_PM, "am");
  else
      strcpy(ShowTC_AM_PM, "pm");
}





//--------------------------------------------------------------

void DSP3_Main_TIME_INFO()
{
  int iTmp, iLen, iOverrideX;
  unsigned int uTmp1;
  char szHour[8];

  //ShowTC_AM_PM[0] = 0;

  process.szDelay[0] = 0;

  iOverrideX = iTimeX;  

  if (iViewToolBar)  
  {
    if (process.Delay_Sign[0] != '?') 
        sprintf(process.szDelay, "A%c%dms", process.Delay_Sign[0], 
                                            process.Delay_ms);
    else
    if (MParse.SystemStream_Flag > 0  // Program Stream
    &&  ! process.Got_PTS_Flag)       // SEQ hdr pkt missing PTS ?
        strcpy(process.szDelay, "NO PTS");
  }


  if ( !iView_TC_Format // Show block number instead of time
  || (CurrTC.RunFrameNum < 1 
       && process.CurrLoc > 0 && ! iPES_Mpeg_Any))
  {
      iTmp = (int) (process.CurrLoc / MPEG_SEARCH_BUFSZ);
      iLen = sprintf(szTemp, "Blk#%06X  %c  %s      ",
                // process.CurrFile,
                iTmp,
                Coded_Pic_Abbr[MPEG_Pic_Type],
                process.szDelay);
  }
  else
  if (iView_TC_Format == 5) // Show in HEX
  {
      iTmp = (int) (process.VideoPTSM & PTS_MASK_0);
      iLen = sprintf(szTemp, "x%08x  %c  %s       ",
                              iTmp,
                Coded_Pic_Abbr[MPEG_Pic_Type],
                process.szDelay);

  }
  else 
  if (iView_TC_Format == 4) // Calc Time od day
  {
      RelativeTC_SET();
      Relative_TOD();

      iLen = sprintf(szTemp, " %02d:%02d :%02d %s %02df   %c  %s      ",
                   ShowTC.hour, ShowTC.minute, ShowTC.sec, 
                                         ShowTC_AM_PM, ShowTC.frameNum,
                                         Coded_Pic_Abbr[MPEG_Pic_Type],
                                         process.szDelay );
  }
  else
  {
     if (iView_TC_Format == 1) // Show time relative to start
     {
              RelativeTC_SET();
              memcpy(&ShowTC, &RelativeTC, sizeof(ShowTC));
     }
     else
     if (iView_TC_Format  == 2  || !MParse.SystemStream_Flag) // GOP time
     {
              memcpy(&ShowTC, &gopTC,      sizeof(ShowTC));
     }
     else
     if (iView_TC_Format  == 3)  // Show time from PTS without adjustment
     {
        if (PktStats.iChk_AudioPackets >  25
        ||  PktStats.iChk_AnyPackets   > 600)
            uTmp1 = process.AudioPTS;
        else
            uTmp1 = process.VideoPTS;

        PTS_2Field(uTmp1, 0);
        memcpy(&ShowTC, &ptsTC,      sizeof(ShowTC));
     }
     else
     if (iView_TC_Format  == 6)  // Show time from SCR
     {
              PTS_2Field( process.uViewSCR, 0);
              memcpy(&ShowTC, &ptsTC,      sizeof(ShowTC));
     }
     else                       
     {
              memcpy(&ShowTC, &CurrTC,     sizeof(ShowTC));
     }     


     if (ShowTC.hour > 00)
         sprintf(szHour, "%dh", ShowTC.hour);
     else
     {
         strcpy(szHour, "  "); 
         // szHour[0]   = 0;
         // iOverrideX +=20;
     }

     if (ShowTC.frameNum < -999 
     ||  ShowTC.frameNum >  999)
         ShowTC.frameNum =  999;

     iLen = sprintf(szTemp, " %s %02dm %02ds %02df %c   %s      ",
                 szHour, ShowTC.minute, ShowTC.sec, ShowTC.frameNum,
                         Coded_Pic_Abbr[MPEG_Pic_Type],
                         process.szDelay );
  }


  // Hiding Toolbar  makes Time less intrusive
  if (! iViewToolBar)  
  {
    if (iMainWin_State > 0)  
      iOverrideX = VGA_Width - (((iLen-11)/2)*18);  // Maximizing Window also makes Time less intrusive
    else
    if (iLen > 20)
        iOverrideX += 50; 
    else
        iOverrideX += 70; 
  }

  if (iLen > 1)
  {
      iLen--;
      TextOut(hDC, iOverrideX, iTimeY, szTemp, iLen) ;
  }

  return;
}









//-------------------------------------------------------------
//Update the context information in the title bar
void DSP5_Main_FILE_INFO()
{
static char FieldMode_Name[4][4] = {"?", "Top", "Bot", "p"};

  int  iTmp1;
  char cTmp1, /*cTmp2,*/ szMantissa[6];
  char *lpszAspect, *ext;


      /*            //RJDBG
               if (DBGflag)
               {
                  int iTmp1, iTmp2, iTmp3, iTmp4, iTmp5;
                  iTmp1 = (int)process.SEQ_Loc;
                  iTmp2 = (int)process.GOP_Loc;
                  iTmp3 = (int)process.KEY_Loc;
                  iTmp4 = (int)process.PIC_Loc;
                  iTmp5 = (int)process.PACK_Loc;
                  //iTmp5  = (int)process.FromLoc;
                  //iTmp6  = (int)process.ToPadLoc;
                  //iTmp11 = (int)process.CurrBlk;
                  //iTmp13 = (int)process.FromBlk;
                  //iTmp15 = (int)process.ToPadBlk;
                  sprintf(szMsgTxt, "Seq=%x Gop=%x Key=%x Pic=%x Pack=%x ",
                                  iTmp1, iTmp2, iTmp3, iTmp4,  iTmp5);
                  //DBGout(szMsgTxt) ;
               }
        */
   // Build Main  Title

   strcpy(szBuffer, szAppName) ;

   //   if (DBGflag)
   //   {
   //      sprintf(szTemp," h=%d %d/%d %d. ",
   //                    iAspect_Height, iLineCtr, iSrcUse, iVertInc ) ;
   //      strcat(szBuffer, szTemp);
   //   }

   // Estimate size of selection & original      RJS
   if (File_Limit)
   {
      //strcat(szBuffer, szName) ;
      ext = strrchr(File_Name[File_Ctr], '\\');
      if (!ext)
        ext = File_Name[File_Ctr] -1;
      strncat(szBuffer, ext+1, 50);
      //strncat(szBuffer, ext+1,
      //           strlen(File_Name[File_Ctr])
      //             -(int)(ext-&File_Name[File_Ctr]));

      if (File_Final)
      {
          sprintf(szTemp, " %d/%d ", (File_Ctr+1), File_Limit);
          strcat(szBuffer, szTemp);
      }

      //process.Delay_ms = process.DelayPTS / 45; //90;

      if ( MParse.SeqHdr_Found_Flag )
      {
         if (iNom_kBitRate > 10000)
         {
            iTmp1 = iNom_kBitRate / 1000;
            cTmp1 = 'M';
         }
         else
         {
            iTmp1 = iNom_kBitRate;
            cTmp1 = 'k';
         }

         if (iFrame_Rate_mantissa)
            sprintf(szMantissa, ".%02d", iFrame_Rate_mantissa);
         else
            szMantissa[0] = 0;

         if (process.Mpeg2_Flag || Mpeg_PES_Version == 2)
           lpszAspect = Mpeg2_Aspect_Ratio_Name[MPEG_Seq_aspect_ratio_code];
         else
           lpszAspect = Mpeg1_Aspect_Ratio_Name[MPEG_Seq_aspect_ratio_code];

         sprintf(szTemp,"  %d.%d%c%c%s %s  %2d%sfps  %d%c/s %s",
                MPEG_Seq_horizontal_size, MPEG_Seq_vertical_size,
                          *ScanMode_Name[ScanMode_code], // Is original progressive frame  (MPEG_Pic_Origin_progressive [progressive_frame] from Pic Coding Extension)
                          *ScanMode_Name[MPEG_Seq_progressive_sequence],
                           FieldMode_Name[MPEG_Pic_Structure], // How is encode structured ? ( [picture_structure] from Pic Coding Extension)
                     lpszAspect,
                    iFrame_Rate_dsp, szMantissa,  iTmp1, cTmp1,
               MPEG_Seq_chroma_Desc[MPEG_Seq_chroma_format]
               /* , iFrame_Period_ms */  ) ;
        strcat(szBuffer, szTemp);
      }

   }


   SetWindowText(hWnd_MAIN, szBuffer);

   if (File_Limit)
   {
      DSP2_Main_SEL_INFO(0);
      DSP3_Main_TIME_INFO();
   }

   DSP1_Main_MSG(0,0);

   return ;
}







HDC hdc_Main;
PAINTSTRUCT ps_Main;

// -------------------------------------------------------------
void Calc_PhysView_Size()
{
    int iTmp1;

    if (IsIconic(hWnd_MAIN))
      return;

    GetClientRect(hWnd_MAIN, &crect);

    iTmp1 = crect.bottom - crect.top - iTopMargin - 2;
    if (iTmp1 > 340)
        iPhysView_Height = iTmp1;
    else
        iPhysView_Height = 340;

    iTmp1 = crect.right - crect.left;
    if (iTmp1 > 280)
        iPhysView_Width  = iTmp1; // - 2;
    else
        iPhysView_Width  = 280;

/*
    if ((VGA_Width  - iPhysView_Width ) < 10
    &&  (VGA_Height - iPhysView_Height) < 10)
        iMaximized = SW_SHOWMAXIMIZED;
    else
        iMaximized = 0;
*/

    iViewMax_Height  = VGA_Height - crect.top + wrect.top
                                  -  iTopMargin;

}






//-------------------------------------------------
/*
void Enable_Disable(int P_Act, int P_Audio, int P_NavButtons )
{
   bool W_Act;
   UINT uAct;

   if (P_Act)
       W_Act = 1;
   else
       W_Act = 0;

  if (W_Act)
  {
      uAct = MF_ENABLED;
      //if (DBGflag) TextOut(hDC,  60,  50, "Enable", 6);
  }
  else
  {
      uAct = MF_GRAYED;
      //if (DBGflag) TextOut(hDC, 100,  50, "Disable", 7);
  }



   EnableWindow(hAddButton,  W_Act);
   //EnableWindow(hLumButton,  W_Act);
   EnableWindow(hBmpButton,  W_Act);
   //EnableWindow(hZoomButton, W_Act);

   if (W_Act)    // Allow scroll while playing
      EnableWindow(hTrack, W_Act);

   if (P_NavButtons)
   {
       EnableWindow(hMarkLeft, W_Act);

       EnableWindow(hBack2, W_Act);
       EnableWindow(hBack1, W_Act);
       EnableWindow(hFwd1, W_Act);
       EnableWindow(hFwd2, W_Act);

       EnableWindow(hMarkRight, W_Act);
   }
   // "Edit" heading in Menu
   //EnableMenuItem(hMenu, 1, (MF_BYPOSITION | uAct));

   // "Audio" heading in Menu
   if (P_Audio && !W_Act)
      EnableMenuItem(hMenu, 5, (MF_BYPOSITION | uAct));

   DragAcceptFiles(hWnd, W_Act);


}
*/



/*
//-------------------------------------------------
void Menu_Main_Enable()
{
   Enable_Disable(true, 0, true);

   EnableMenuItem(hMenu, IDM_OPEN,         MF_ENABLED);
   EnableMenuItem(hMenu, IDM_FILE_NAMES,   MF_ENABLED);
   EnableMenuItem(hMenu, IDM_SAVE,         MF_ENABLED);
   EnableMenuItem(hMenu, IDM_FILE_NEWNAME, MF_ENABLED);
//   EnableMenuItem(hMenu, IDM_LOAD_D2V, MF_ENABLED);
//   EnableMenuItem(hMenu, IDM_SAVE_D2V, MF_ENABLED);
//   EnableMenuItem(hMenu, IDM_STOP, MF_GRAYED);

   //SendMessage(hTrack, TBM_SETSEL, (WPARAM) true,
   //                  (LPARAM) MAKELONG(process.trackleft,
   //                                             process.trackright));

   DrawMenuBar(hWnd);
}
*/


//-----------------------------------
void Menu_Main_Disable(int P_audio, int P_NavButtons)
{

   //EnableMenuItem(hMenu, IDM_FILE_NEWNAME, MF_GRAYED);

   //Enable_Disable(false, P_audio, P_NavButtons);

   if (hLumDlg!=NULL && P_NavButtons)
   {
      DestroyWindow(hLumDlg);
      hLumDlg = NULL;
   }

/*   if (hClipResizeDlg!=NULL)
   {
      DestroyWindow(hClipResizeDlg);
      hClipResizeDlg = NULL;
   }
   if (hNormDlg!=NULL)

      DestroyWindow(hNormDlg);
      hNormDlg = NULL;
   }
*/

}



//-------------------------------------------------

void CalcRestoreSize(int p_width, int p_height)
{
int Max_Width, Max_Height ;

   Max_Width = VGA_Width - 160 ;
   if ((VGA_Width > 640) && (Coded_Pic_Width > Max_Width))
      Restore_Width  = Max_Width ;
   else
      Restore_Width  = p_width ;



   Max_Height = VGA_Height - Edge_Width - iTopMargin ;
   if ((VGA_Height > 480) && (Coded_Pic_Height > Max_Height))
         Restore_Height = Max_Height ;
   else
         Restore_Height = p_height ;



/*   if (IsMaximized(hWnd))
   {
      if (p_width  < Max_Width)  Overlay_Width   =    p_width ;
      else                       Overlay_Width   = Max_Width ;
      if (p_height < Max_Height) Overlay_Height =    p_height ;
      else                       Overlay_Height = Max_Height ;
   }
   else
*/   {
      Overlay_Width  = Restore_Width ;
      Overlay_Height = Restore_Height ;
   }

}



//--------------------------
void View_Ctr_Crop()
{
  if (DBGflag)
      DBGout("CTR");

   iPred_Prev_Width  = 0; 

   /*
   if (iView_Centre_Crop)
   {
       iTmp1 = (iAspect_Width / 3) &  0xFFFFFFFE;
       if (iView_xFrom < iTmp1)
           iView_xFrom = iTmp1;
   }
   */

   if (!iMainWin_State)
   {
      Mpeg_Aspect_Resize();
      View_Rebuild_Chk(0);
   }

}


//--------------------------
void View_ReSize_Chk(int P_Force)
{
  if (MParse.SeqHdr_Found_Flag)
  {
     if (P_Force 
     || (  (   iAspect_Width  != Prev_Clip_Width
            || iAspect_Height != Prev_Clip_Height)
          &&   ! MParse.iMultiRqst
          && iShowVideo_Flag
         ))
     {
             D500_ResizeMainWindow(iAspect_Width, iAspect_Height, 0);
             Prev_Clip_Width  = iAspect_Width;
             Prev_Clip_Height = iAspect_Height;
     }
  }
}


//--------------------------
void   View_Rebuild_Chk(int P_Force)
{
  if (DBGflag)
      DBGout("Rebuild");

  if (MParse.SeqHdr_Found_Flag)
  {
     View_ReSize_Chk(P_Force);

     if (iShowVideo_Flag && File_Limit)
     {
        if (!iBusy)
        {
          if (MParse.Store_Flag==STORE_YUY2 && ! DDOverlay_Flag)
          {
             D100_CHECK_Overlay();
          }

          if (prect.right && prect.bottom)
          {
             if (DDOverlay_Flag)
                 D200_UPD_Overlay();

             if (MParse.Stop_Flag || MParse.Tulebox_SingleStep_flag)
             {
                if (MParse.Store_Flag != STORE_YUY2)
                    RenderRGB24();
                else
                if (DDOverlay_Flag)
                    RenderYUY2(1);
             }
          } // endif got a picture

        } // endif !Busy

        DSP3_Main_TIME_INFO(); 
        if (iViewToolBar) //  || iTool_Stacked)
        {
             DSP2_Main_SEL_INFO(1);
        }

     } // endif ShowVideo
  } // endif SEQ HDR found

}


//----------------------------------------------------------------
void View_MOUSE_ALIGN(LPARAM lParam)
{
  int xPos, yPos, iOverrideX;

const char *TimeFmtName[7] // for iView_TC_Format
   = { "BLK",  "Rel",  "GOP",   "PTS",  "TOD", "PTS", "SCR"}; 
  


  if (DBGflag)
      DBGout("MouseAlign");


  if (MParse.SeqHdr_Found_Flag)
  {
      Mpeg_Aspect_Resize();  // In case Zoom has changed;
      //View_ReSize_Chk(0);
  }
  
  // X

  if (lParam > -1)
  {
      xPos = (int)(LOWORD(lParam));
      yPos = (int)(HIWORD(lParam)) - iTopMargin;

      if (yPos < 10) // Mouse in or near text area ?
      {
        if (yPos >= -iTimeY)
        {
          iOverrideX = iTimeX-40;
          if (xPos >= iOverrideX)  // Mouse on Time Coordinate ?
          {
            if (iView_TC_Format < 6)
                iView_TC_Format++;
            else
                iView_TC_Format = 0;

            if (!iViewToolBar)
               iOverrideX += 45;

            TextOut(hDC, iOverrideX, iTimeY, BLANK44, 40) ;
            TextOut(hDC, iOverrideX, iTimeY, TimeFmtName[iView_TC_Format], 3) ;
            DSP3_Main_TIME_INFO();
          }
        }
      }
      else
      {
        iView_xFrom = (iView_xFrom +
                      ( (xPos - iPhysView_Width/2) * iZoom)
                         * iAspHoriz / 2048)
                                 & 0xFFFFFFFC ;
      }
  }


  if (iView_xFrom < 0)
      iView_xFrom = 0;
  else
  {
      if (iView_xFrom > iOverload_Width)
          iView_xFrom = iOverload_Width;// + 2;
  }

  // Y

  if (lParam > -1)
  {
      if (yPos > 0)
      {
         iView_yFrom = iView_yFrom +
                       ( (yPos - (iPhysView_Height/2) )
                                   * iAspVert / 2048);
      }
  }


  if (iView_yFrom < 0)
      iView_yFrom = 0;
  else
  if (iView_yFrom > iOverload_Height)
      iView_yFrom = iOverload_Height ; //+ 2;
   

  iView_yFrom = iView_yFrom & 0xFFFFFE;
  if (MParse.SeqHdr_Found_Flag)
      Mpeg_Aspect_Calc();  // In case Zoom has changed;

  View_Rebuild_Chk(0);
}






void B170_Msg_Clear()
{
  RECT msgrect;

  int iWidth;

  //if (! iViewToolBar)
  //    SetBkColor(hDC, iCtl_Mask_Colour);  // Background = Overlay key
  
  //TextOut(hDC,  0,  iMsgPosY,  BLANK44,  44);  //  Would  be  better  as  a  Paint
  // iWidth = iSelMsgX;
  if (iTimeY > iMsgPosY)
   iWidth = iAspect_Width-1;
  else
   iWidth = iTimeX;

  iMsgLen  =  0;

  SetRect(&msgrect, 0, iMsgPosY, iWidth, (iMsgPosY+iTool_Ht)); //  iTool_Ht * 4 / 5)) );
  FillRect(hDC, &msgrect, hBrush); 

  if (process.Action != ACTION_RIP    // Hide boring stuff while playing
  ||  iPreview_Clip_Ctr <= 500        // Not a ClipList Preview
  || (!iMainWin_State && iViewToolBar) ) 
  {
     DSP2_Main_SEL_INFO(0); // Repair Clip info
  }


  //if (! iViewToolBar)
  //   SetBkColor(hDC, iCtl_Back_Colour);  // Background = black

}



//--------------------------------------------------------------
void MainPaint()
{
         hdc_Main = BeginPaint(hWnd_MAIN, &ps_Main);
         EndPaint(hWnd_MAIN, &ps_Main);
         ReleaseDC(hWnd_MAIN, hdc_Main);

         if (MParse.SeqHdr_Found_Flag && MParse.Store_Flag==STORE_RGB24)
            RenderRGB24();
}


