

#define DBG_RJ

// Initalize Mpeg2 Video Decoder.
// Allocates and sub-allocates picture work area buffers

#include  "global.h"
#include "MPV_PIC.h"
#include "PIC_BUF.h"

//------------------

int Old_Pic_Width=720,   Old_Pic_Height=576,  Old_Pic_Size = 720*576;
int Old_Pic_Reset=0;
int Old_Seq_Width=2048,  Old_Seq_Height=2048;
int iWarned2k=0;


void Derived_Sizes()
{
  mb_width  = (MPEG_Seq_horizontal_size+15)/16;
  mb_height =  MPEG_Seq_progressive_sequence
            ?     (MPEG_Seq_vertical_size+15)/16
            :  2*((MPEG_Seq_vertical_size+31)/32)  ;


  //  Trap BAD canvas size leading to huge mallocs or crashes, etc

  if  (  !  mb_width)   mb_width  =  1;
  if  (  !  mb_height)  mb_height =  1;

  Coded_Pic_Width    =  16  *  mb_width;
  Coded_Pic_Height   =  16  *  mb_height;

  DOUBLE_WIDTH  =  Coded_Pic_Width<<1;
  HALF_WIDTH    =  Coded_Pic_Width>>1;


  Coded_Pic_Size =  Coded_Pic_Width  *  Coded_Pic_Height  ;


  Chroma_Width   =  (MPEG_Seq_chroma_format  ==  CHROMA444)
                        ?  Coded_Pic_Width  :  Coded_Pic_Width>>1;

  Chroma_Height  =  (MPEG_Seq_chroma_format    >  CHROMA420)  //  !=  CHROMA420)
                        ?  Coded_Pic_Height  :  Coded_Pic_Height>>1;

  Chroma_Size    =  Chroma_Width  *  Chroma_Height  ;

  Clip_Width     =  Coded_Pic_Width;
  Clip_Height    =  Coded_Pic_Height;


  Mpeg_MacroBlk_Array_Limit  =  ChromaFormat[MPEG_Seq_chroma_format];

}




void  Decoder_INIT()
{
  //int Max_Height, Max_Width;
  int iNewBuffers, iSize, iChannel;
  int iRC, iTmp1;

  if (DBGflag)
      DBGout("Decoder Init");


  Old_Pic_Reset = 0;

  //  Trap BAD canvas size leading to huge mallocs or crashes, etc
  {
      if (MPEG_Seq_horizontal_size != Old_Seq_Width
      ||  MPEG_Seq_vertical_size   != Old_Seq_Height)
      {
          if ((MPEG_Seq_horizontal_size &3)
          ||  (MPEG_Seq_vertical_size   &3)
          ||   MPEG_Seq_horizontal_size > 1920
          ||   MPEG_Seq_vertical_size   > 1080)
          {
              sprintf(szMsgTxt, "ODD/MIXED CANVAS SIZE %d.%d **",  
                                 MPEG_Seq_horizontal_size,
                                MPEG_Seq_vertical_size);
              DSP1_Main_MSG(0,0);
              MessageBeep(MB_OK);

              if (MParse.SeqHdr_Found_Flag)
              {
                 MPEG_Seq_horizontal_size = Old_Seq_Width;
                 MPEG_Seq_vertical_size   = Old_Seq_Height;
                 Old_Pic_Reset = 1;
              }
          }
      }
  }
  

  if (MPEG_Seq_horizontal_size > 2048
  ||  MPEG_Seq_vertical_size   > 2048)
  {
      sprintf(szMsgTxt, "Pic dimension > 2048\n\nSize = %d.%d\n\nCould crash on some systems !\n\nForce 2k Limit ?",
                              MPEG_Seq_horizontal_size,
                              MPEG_Seq_vertical_size);

      if (iView_Limit2k > 0 && !MParse.SeqHdr_Found_Flag)
      { 
           iRC =  Warning_Box(&szMsgTxt[0], 0, &iTmp1, IDM_VIEW_HUGE, MB_OKCANCEL);
           if (iRC == IDCANCEL)
               iView_Limit2k = 0;
           else
               iView_Limit2k = 1;

           if (iTmp1)
           {
               iCtl_View_Limit2k = iView_Limit2k;
               Set_Toggle_Menu('=', &iCtl_View_Limit2k, IDM_VIEW_HUGE);
           }
      }
      else
      {
           DSP1_Main_MSG(0,0);
           MessageBeep(MB_OK);
           if (!iWarned2k)
           {
             iWarned2k = 1;
             Sleep(1000);
           }
      }


      if (iView_Limit2k)
      {
          if (MPEG_Seq_horizontal_size > 2048)
              MPEG_Seq_horizontal_size = 2048;
          if (MPEG_Seq_vertical_size   > 2048)
              MPEG_Seq_vertical_size   = 2048;

          Old_Pic_Reset = 1;
      }
  }



  //  Don't  let  ridiculous  data  crash  DirectDraw
  if  (MPEG_Seq_horizontal_size  >  8192  || MPEG_Seq_horizontal_size < 8)
  {
      sprintf(szMsgTxt, "WIDTH %d BAD **",  MPEG_Seq_horizontal_size);
      DSP1_Main_MSG(0,0);
      MessageBeep(MB_OK);
      Old_Pic_Reset = 1;
  }


  if  (MPEG_Seq_vertical_size  >  4096  || MPEG_Seq_vertical_size < 8)
  {
      sprintf(szMsgTxt, "HEIGHT %d BAD **",  MPEG_Seq_vertical_size);
      DSP1_Main_MSG(0,0);
      MessageBeep(MB_OK);
      Old_Pic_Reset = 1;
  }

  Derived_Sizes();

  iNewBuffers = 0;

  if (Coded_Pic_Size != PicBuffer_Canvas_Size) 
  {
     if (Coded_Pic_Size > PicBuffer_Canvas_Size) 
     {
         PicBuffer_Alloc();
         iNewBuffers = 1;
     }
     else
     {
         iView_Fast_YUV = 0;
         iView_Fast_RGB = 0;
     }
  }


  if (Old_Pic_Reset)
  {
      MPEG_Seq_horizontal_size = Old_Seq_Width; // Max_Width;
      MPEG_Seq_vertical_size   = Old_Seq_Height; // Max_Height;

      Derived_Sizes();

      if (DBGflag)
      {
          sprintf(szDBGln, "RESET %d.%d", 
                            MPEG_Seq_horizontal_size,
                            MPEG_Seq_vertical_size);
         DBGout(szDBGln);
      }

  }
  else
  {
     if (Old_Seq_Width  != MPEG_Seq_horizontal_size
     ||  Old_Seq_Height != MPEG_Seq_vertical_size)
     {
         if (DBGflag)
         {
            sprintf(szBuffer, "NEW SIZE=%d.%d\nold=%d.%d  ",
                          MPEG_Seq_horizontal_size, MPEG_Seq_vertical_size,
                    Old_Seq_Width, Old_Seq_Height);
            DBGout(szBuffer);
         }

         if (DDOverlay_Flag) //  && !MParse.SizeCommitted)
             D300_FREE_Overlay();
         Old_Seq_Width  = MPEG_Seq_horizontal_size;
         Old_Seq_Height = MPEG_Seq_vertical_size;

         iCtl_Zoom = -1;  // Reset Zoom default to auto setting
         iPhysView_Width  = VGA_Width;
         //iPhysView_Height = VGA_Height;
     }

      // If reusing old buffers,
      // clear out picture when new process begun
 
      if (!Frame_Number && ! iNewBuffers)
      {
        for  (iChannel = 0;  
             iChannel < 1; // 3;  // Only do Y.  Don't really care about U,V 
             iChannel++) 
        {
           if  (iChannel==0)
                iSize  =  PicBuffer_Canvas_Size;
           else
                iSize  =  Chroma_Size;

           memset(bwd_ref_frame[iChannel], 0x00, iSize);
           memset(fwd_ref_frame[iChannel], 0x00, iSize);
           memset(aux_frame    [iChannel], 0x00, iSize);
        }

        //memset(LumAdjBuf,          0x00,  PicBuffer_Canvas_Size);
        //memset(yuy2,         0x00, (PicBuffer_Canvas_Size*2));
        //memset(rgb24,        0x00, (PicBuffer_Canvas_Size*3));

      } // end-if clearing buffers

  } // end-if new size valid


  if (Coded_Pic_Width)
      Mpeg_Aspect_Resize();
  else
  {
      sprintf(szMsgTxt,  "Width=%d",  Coded_Pic_Width);
      iVertInc  =  0  ;
      iAspVert  =  2048;  iAspHoriz  =  2048;
      iAspect_Height  =  Coded_Pic_Height;
  }

  if (!DDOverlay_Flag   && !iCtl_View_RGB_Always
  &&  MParse.Store_Flag != STORE_RGB24)
      D100_CHECK_Overlay(); 
  
  MParse.ReInit = 1;  MParse.SizeCommitted = 1;

  if (DBGflag)
      DBGout("Decoder Rdy");
}


//-------------------
void Mpeg_Drop_Init()
{
     if (MParse.FastPlay_Flag)
         PlayCtl.iDrop_Behind   = 257;
     else
         PlayCtl.iDrop_Behind    =  iCtl_Drop_Behind;

     PlayCtl.iDrop_PTS_Flag  =  iCtl_Drop_PTS;

     if  (iAudio_Track_SEL  !=  TRACK_NONE 
     &&   ! iView_FrameRate_Code)
          iAudio_Lock  =  iCtl_Play_AudLock;

     if (PlayCtl.iDrop_Behind && MPEG_Pic_Structure == 3  // Not supported on full interlace
     && ! MParse.SlowPlay_Flag)
     {
         if (PlayCtl.iDrop_Behind > 1            // Drop allowed on SD ?
         && (Coded_Pic_Height > 576 || iFrame_Rate_int > 33)) 
         {
             if (cpu.sse2 || cpu._3dnow)  // Pentium 4 or better 
                 PlayCtl.iDrop_B_Frames_Flag = 1;
             else
                 PlayCtl.iDrop_B_Frames_Flag = 2;
         }
         else
         {
             if (cpu.ssemmx)  // Pentium 3 or better
                 PlayCtl.iDrop_B_Frames_Flag = 1;
             else
                PlayCtl.iDrop_B_Frames_Flag = 2;
         }
     }

     if ( ! iCtl_ShowVideo_Flag)
     {
         PlayCtl.iDrop_Behind        = 257;
         PlayCtl.iDrop_B_Frames_Flag = 3;
     }
}

//---------------------------------------------------------
//  allocate  mem  area  as  internal  sub-pool,  mimics  "malloc"
unsigned  char  *  suballoc(int  P_Size)
{
unsigned  char  *  iPtr;

  iPtr        =  (unsigned  char  *)((int)(subpool_ptr    +  64)  &  0xFFFFFFC0);
  subpool_ptr  =  iPtr  +  P_Size;      //  ((iPtr  +  P_Size  +  64)  &  0xFFFFFFC0)  ;

return  iPtr;
}



//----------------------
void  PicBuffer_Alloc()
{
  int  i,  size,  SafeTotal, iGenerous;
  int  SafeWidth,  SafeHeight,    SafeSize  ;
  int  SafeCWidth,  SafeCHeight,  SafeCSize  ;

  if (DBGflag)
  {
    DBGout("BUFF");
  }

  if  (PicBuffer_Canvas_Size  >  0)
       PicBuffer_Free();

  //  RJ
  //  Changed  buffer  allocation  strategy  for  fault  tolerance
  //  Single  GetMain  for  combined  buffer  area,  with  padding,
  //  which  I  then  suballocate,
  //  with  the  safest  buffers  at  each  end,
  //  and  the  risky  buffers  in  the  middle
  
  //  First,  add  some  padding  to  all  the  dimensions

  SafeWidth    =  Coded_Pic_Width   +  8;
  SafeHeight   =  Coded_Pic_Height  +  8;

  SafeSize     =  SafeWidth * SafeHeight;

  if (cpu.sse2)
     iGenerous = 1928*1088;
  else
     iGenerous = 1024*1024;
  
  if (SafeSize < iGenerous)
      SafeSize = iGenerous;

  PicBuffer_Canvas_Size = SafeSize;

  SafeCWidth    =  Chroma_Width  +  8;
  SafeCHeight   =  Chroma_Height +  8;
  SafeCSize     =  SafeCWidth * SafeCHeight;

  iGenerous = iGenerous/2;
  if (SafeCSize < iGenerous)
      SafeCSize = iGenerous;

  //  Calculate  total  size  of  buffers  to  be  pooled
  //      RJ  -  WOW  -  It's  a  big  whack  -  may  be  able  to  trim  this  down  one  day  ?
  SafeTotal    =  ((SafeSize+64) *  12) +  ((SafeCSize+64) * 6) + 8192
                  +  8  *  (sizeof(short)*64  +    64)
                  +         sizeof(float)*128 +  8192;

  //  Allow  for  experimentation
  if  (Mpeg_PES_Version != 2  &&  SafeSize < (768*576))
       SafeTotal = SafeTotal * 2;

  frame_pool  =  (unsigned  char*)malloc(SafeTotal);
  if (frame_pool == NULL)
      Err_Malloc(&"PicBuf");


  //  Now  we  sub  allocate  into  various  frame  work  areas
  subpool_ptr  =  (unsigned char *)(frame_pool + 4096);

  //  Allow  for  experimentation
  if  (Mpeg_PES_Version  !=  2  &&  SafeSize  <  (768  *  576))
      subpool_ptr  +=  SafeSize;

  //  Safe  buffers  (less  likely  to  cause  crash)
  u444  =  (unsigned  char*)suballoc(SafeSize);
  v444  =  (unsigned  char*)suballoc(SafeSize);
    //  RJ  Moved  here  from  GUI  initialization
  //  Allocate  memory  for  macroblock  tiles

  for  (i=0;  i<16;  i++)
  {
    p_block[i]  =  (short  *)suballoc(sizeof(short)*64  +  64);
    block[i]    =  (short  *)((long)p_block[i]  +  64
                           -  (long)p_block[i]%64);
  }

  p_fTempArray  =  (void  *)malloc(sizeof(float)*128  +  64);
  if (p_fTempArray == NULL)
      Err_Malloc(&"TempArray");

  fTempArray    =  (void  *)((long)p_fTempArray  +  64
                          -  (long)p_fTempArray%64);


  for  (i=0;  i<3;  i++)
  {
    if  (i==0)
      size  =  SafeSize  ;
    else
      size  =  SafeCSize ;

    bwd_ref_frame   [i] = (unsigned char*)suballoc(size);
  //end_bwd_ref     [i] = bwd_ref_frame[i] + size - 64 ;
    curr_frame      [i] = bwd_ref_frame[i];
    curr_full_frame [i] = curr_frame   [i];

    fwd_ref_frame   [i] = (unsigned char*)suballoc(size);
  //end_fwd_ref     [i] = fwd_ref_frame[i] + size - 64;

    aux_frame[i]     = (unsigned char*)suballoc(size);
    //end_aux[i]       = aux_frame[i] + size - 64 ;
  }


  // DTV is mostly 4:2:0, for both SD and HD
  // therefore this is a high risk area, 
  // so stick it in the middle of the buffer area
  u422  = (unsigned char*)suballoc(SafeSize/2);
  v422  = (unsigned char*)suballoc(SafeSize/2);

  yuy2  = (unsigned char*)suballoc(SafeSize*2);
  LumAdjBuf   = (unsigned char*)suballoc(SafeSize);
  //sat   = (unsigned char*)suballoc(SafeSize);


// Allocate rgb24 here because not used when overlay available
// Allocated last in case it proceeds backwards too far
  RGB24_size = SafeSize*3;
  rgb24 = (unsigned char*)suballoc(RGB24_size);

// rgb24 Zoom line work area
  rgbZoomLine = (unsigned char*)suballoc(8192);


}


//---------------------
void PicBuffer_Free()
{
  int i;

  if (PicBuffer_Canvas_Size < 1)
     return;

  PicBuffer_Canvas_Size = 0;

  // Free the big frame pool

  free(frame_pool);

  if (DBGflag)
  {
      DBGout("Frame Pool Freed");
  }


  for (i=0; i<3; i++)
  {
      // RJ *** No longer have individual frame mallocs to free ***
      bwd_ref_frame[i] = 0;      //    free(bwd_ref_frame[i]);
      fwd_ref_frame[i] = 0;      //    free(fwd_ref_frame[i]);
      aux_frame    [i] = 0;      //    free(aux_frame[i]);
      curr_frame   [i] = 0;
  }
      // RJ *** No longer have individual frame mallocs to free ***
  //free(u422);    free(v422);    free(u444);    free(v444);
  //free(rgb24);   free(yuy2);   
  //free(LumAdjBuf);

  // ** USED TO CRASH HERE WHEN COMPILED WITH DEBUG - DUNNO WHY
  return;
}

