//
// When I try to compile this as a separate module
// I end up with Link errors later 
// so it is still an "include" of GUI.CPP
//

#include "windows.h"

#include "global.h"
#define true 1
#define false 0
#include <commctrl.h>




HWND hLumDlg0;



void Lum_SetNum_Gain()
{
  sprintf(szTemp, "%d", iLumGain[iColorSpaceTab]-128);
  SetDlgItemText(hLumDlg0, IDC_CONTRAST, szTemp);
}

void Lum_SetPos_Gain()
{
  SendDlgItemMessage(hLumDlg0, IDC_CONTRAST_SLIDER, TBM_SETPOS, 1, iLumGain[iColorSpaceTab]);
  Lum_SetNum_Gain();
}


//--------

void Lum_SetNum_Offset()
{
  sprintf(szTemp, "%d", iLumOffset[iColorSpaceTab]);
  SetDlgItemText(hLumDlg0, IDC_BRIGHT, szTemp);
}

void Lum_SetPos_Offset()
{
  SendDlgItemMessage(hLumDlg0, IDC_BRIGHT_SLIDER, TBM_SETPOS, 1, iLumOffset[iColorSpaceTab]+128);
  Lum_SetNum_Offset();
}

//--------

void Lum_SetNum_Gamma()
{
  sprintf(szTemp, "%3d", iLumGamma[iColorSpaceTab] );
  SetDlgItemText(hLumDlg0, IDC_GAMMA, szTemp);
}




//--------

void Lum_SetNum_Sat()
{
  sprintf(szTemp, "%d", iSatGain[iColorSpaceTab]-100);
  SetDlgItemText(hLumDlg0, IDC_SAT_GAIN, szTemp);
}

void Lum_SetPos_Sat()
{
  SendDlgItemMessage(hLumDlg0, IDC_SAT_SLIDER, TBM_SETPOS, 1, 
                               iSatGain[iColorSpaceTab]);
  Lum_SetNum_Sat();
}


//--------


void Lum_SetNum_Blue()
{
  sprintf(szTemp, "%3d", iSatAdd_U);
  SetDlgItemText(hLumDlg0, IDC_BLUE_OFFSET, szTemp);
}
void Lum_SetPos_Blue()
{
  SendDlgItemMessage(hLumDlg0, IDC_BLUE_SLIDER, TBM_SETPOS, 1, iSatAdd_U);
  Lum_SetNum_Blue();
}

//--------

void Lum_SetNum_Red()
{
  sprintf(szTemp, "%3d", iSatAdd_V);
  SetDlgItemText(hLumDlg0, IDC_RED_OFFSET, szTemp);
}

void Lum_SetPos_Red()
{
  SendDlgItemMessage(hLumDlg0, IDC_RED_SLIDER, TBM_SETPOS, 1, iSatAdd_V);
  Lum_SetNum_Red();
}

//--------




void Lum_SetPos_Sliders()
{
  Lum_SetPos_Gain();
  Lum_SetPos_Offset();

  SendDlgItemMessage(hLumDlg0, IDC_GAMMA_SLIDER,  TBM_SETPOS, 1, iLumGamma[iColorSpaceTab]);
  Lum_SetNum_Gamma();

  Lum_SetPos_Sat();
  Lum_SetPos_Blue();
  Lum_SetPos_Red();
}


void LumLock_Bright()
{
  iLumOffset[iColorSpaceTab] = iLumGain[iColorSpaceTab] - 128;
  Lum_SetPos_Offset();
}


void LumLock_Gain()
{
  iLumGain[iColorSpaceTab] = (iLumOffset[iColorSpaceTab]) + 128;
  Lum_SetPos_Gain();
}


void SatLock_Blue()
{
  iSatAdd_U =  iSatAdd_V / 3;
  Lum_SetPos_Blue();
}

void SatLock_Red()
{
  iSatAdd_V =  iSatAdd_U * 3;
  Lum_SetPos_Red();
}



void Lum_SetRange(UINT P_Control, UINT P_Base, UINT P_Range, UINT P_TicFreq)
{
  SendDlgItemMessage(hLumDlg0, P_Control, TBM_SETRANGE, 0,
                                 MAKELPARAM(P_Base, P_Range));

  SendDlgItemMessage(hLumDlg0, P_Control, TBM_SETTICFREQ, 
                                               P_TicFreq, 0);
}



void Lum_Show_All()
{

  if (iLumGamma[iColorSpaceTab] > 400) iLumGamma[iColorSpaceTab] = 400;
  if (iLumGamma[iColorSpaceTab] <   0) iLumGamma[iColorSpaceTab] =   0;

  Lum_SetPos_Sliders();

  if (iLumEnable_Flag[iColorSpaceTab])
      SendDlgItemMessage(hLumDlg0, IDC_LUM_CHECK, BM_SETCHECK,
                                                  BST_CHECKED, 0);
  else
      SendDlgItemMessage(hLumDlg0, IDC_LUM_CHECK, BM_SETCHECK,
                                                  BST_UNCHECKED, 0);
  if (iLumLock_Flag)
      SendDlgItemMessage(hLumDlg0, IDC_LUMLOCK_CHK, BM_SETCHECK,
                                                  BST_CHECKED, 0);
  else
      SendDlgItemMessage(hLumDlg0, IDC_LUMLOCK_CHK, BM_SETCHECK,
                                                  BST_UNCHECKED, 0);

  if (iSatAdj_Flag)
      SendDlgItemMessage(hLumDlg0, IDC_LUM_SAT,   BM_SETCHECK,
                                                  BST_CHECKED, 0);
  else
      SendDlgItemMessage(hLumDlg0, IDC_LUM_SAT,   BM_SETCHECK,
                                                  BST_UNCHECKED, 0);
         
  if (iSatLock_Flag)
      SendDlgItemMessage(hLumDlg0, IDC_SATLOCK_CHK, BM_SETCHECK,
                                                  BST_CHECKED, 0);
  else
      SendDlgItemMessage(hLumDlg0, IDC_SATLOCK_CHK, BM_SETCHECK,
                                                  BST_UNCHECKED, 0);

   ShowWindow(hLumDlg0, SW_SHOW);
}



//----------------------------------------------------------------
LRESULT CALLBACK Luminance_Dialog(HWND hDialog, UINT message,
                                WPARAM wParam, LPARAM lParam)
{

  static int iLast_Y_Slider=0, iLast_UV_Slider=0, iLast_Reset=1;
  static int iOrig_ColorSpace=0;

  int iTmp1;

  hLumDlg0 = hDialog;

  switch (message)
  {
     case WM_INITDIALOG:

         iOrig_ColorSpace = MParse.Store_Flag;

         if (MParse.Store_Flag == STORE_YUY2)
           iTmp1 = IDC_LUMTAB_OVL;
         else
         {
           iTmp1 = IDC_LUMTAB_RGB;
           iColorSpaceTab = 1;
         }
         SendDlgItemMessage(hLumDlg0, iTmp1, BM_SETCHECK, BST_CHECKED, 0);

         Lum_SetRange(IDC_GAMMA_SLIDER,    0, 402, 256);
         Lum_SetRange(IDC_CONTRAST_SLIDER, 0, 512, 128);
         Lum_SetRange(IDC_BRIGHT_SLIDER,   0, 512, 128);

         Lum_SetRange(IDC_SAT_SLIDER, -99, 400,  64);
         Lum_SetRange(IDC_BLUE_SLIDER, -20,  20,  20);
         Lum_SetRange(IDC_RED_SLIDER,  -20,  20,  20);

         Lum_Show_All();

         return true;


     case WM_COMMAND:
        switch (LOWORD(wParam))
        {
          case IDC_LUMTAB_OVL:
               iColorSpaceTab = 0;
               SendDlgItemMessage(hLumDlg0, IDC_LUMTAB_OVL, BM_SETCHECK,
                                                            BST_CHECKED, 0);
               SendDlgItemMessage(hLumDlg0, IDC_LUMTAB_RGB, BM_SETCHECK,
                                                            BST_UNCHECKED, 0);
               Lum_Show_All();
               //Lum_Filter_Init(0);

               Chg2YUV2(1) ;

               //RefreshVideoFrame();
               break;

          case IDC_LUMTAB_RGB:
               iColorSpaceTab = 1;
               SendDlgItemMessage(hLumDlg0, IDC_LUMTAB_RGB, BM_SETCHECK,
                                                            BST_CHECKED, 0);
               SendDlgItemMessage(hLumDlg0, IDC_LUMTAB_OVL, BM_SETCHECK,
                                                            BST_UNCHECKED, 0);
               Lum_Show_All();

               //Lum_Filter_Init(1);
               Chg2RGB24(1) ;
               //RefreshVideoFrame();
               break;


          case IDL_LUM_BOLD:
               iLast_Reset = 1;
               iLumEnable_Flag[iColorSpaceTab] = 1;
               iLumGain[iColorSpaceTab]   = 168; 
               iLumOffset[iColorSpaceTab] = 40; 

               //if (iColorSpaceTab)
               //  iTmp1 = 150;
               //else
               //  iTmp1 = 130;
               iLumGamma[iColorSpaceTab] = 110; //iTmp1;

               Lum_Show_All();  // Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;


          case IDL_SAT_RESET:
               iSatAdd_U   = 1;   iSatAdd_V   = 1;
               iSatGain[0] = 100; iSatGain[1] = 100;
               iSatAdj_Flag = 1;  iSatLock_Flag = 0;

               Lum_Show_All();  // Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;


          case IDL_LUM_RESET:
               iLast_Reset = 1;
               iLumGain[iColorSpaceTab] = 128; 
               iLumOffset[iColorSpaceTab] = 0; 

               //if (iColorSpaceTab)
               //  iTmp1 = 150;
               //else
               //  iTmp1 = 130;
               iLumGamma[iColorSpaceTab] = 130; //iTmp1;

               Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;


          case IDL_SAT_BOLD:
               iSatAdd_U   = 2;   iSatAdd_V   = 6;
               iSatGain[0] = 100; iSatGain[1] = 100;
               iSatAdj_Flag = 1;  iSatLock_Flag = 0;

               Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;


          case IDL_LUM_ZERO:
               iLast_Reset = 0;

               iLumGain[iColorSpaceTab] = 128; 
               iLumOffset[iColorSpaceTab] = 0; 

               //if (iColorSpaceTab)
               //  iTmp1 = 150;
               //else
               //  iTmp1 = 130;
               iLumGamma[iColorSpaceTab] = 100; //iTmp1;

               Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;


          case IDL_SAT_ZERO:

               iSatAdd_U   = 0;   iSatAdd_V   = 0; 
               iSatGain[0] = 100; iSatGain[1] = 100;

               Lum_SetPos_Sliders();

               RefreshVideoFrame();
               break;



          case IDC_LUM_CHECK:
               if (SendDlgItemMessage(hLumDlg0,
                       IDC_LUM_CHECK, BM_GETCHECK, 1, 0) == BST_CHECKED)
               {
                  CheckMenuItem(hMenu, IDM_LUMINANCE, MF_CHECKED);
                  iLumEnable_Flag[iColorSpaceTab] = true;
               }
               else
               {
                  CheckMenuItem(hMenu, IDM_LUMINANCE, MF_UNCHECKED);
                  iLumEnable_Flag[iColorSpaceTab] = false;
               }

               RefreshVideoFrame();
               break;




          case IDC_LUM_SAT:
               if (SendDlgItemMessage(hLumDlg0,
                         IDC_LUM_SAT, BM_GETCHECK, 1, 0) == BST_CHECKED)
                  iSatAdj_Flag = true;
               else
                  iSatAdj_Flag = false;

               RefreshVideoFrame();
               break;


          case IDC_LUMLOCK_CHK:
               if (SendDlgItemMessage(hLumDlg0,
                       IDC_LUMLOCK_CHK, BM_GETCHECK, 1, 0) == BST_CHECKED)
               {
                  iLumLock_Flag = true;
                  if (iLast_Y_Slider == IDC_CONTRAST_SLIDER)
                      LumLock_Bright();
                  else
                      LumLock_Gain();

               }
               else
               {
                  iLumLock_Flag = false;
               }

               RefreshVideoFrame();
               break;



          case IDC_SATLOCK_CHK:
               if (SendDlgItemMessage(hLumDlg0,
                       IDC_SATLOCK_CHK, BM_GETCHECK, 1, 0) == BST_CHECKED)
               {
                  iSatLock_Flag = true;

                  if (iLast_UV_Slider == IDC_BLUE_SLIDER)
                      SatLock_Red();
                  else
                      SatLock_Blue();
               }
               else
               {
                  iSatLock_Flag = false;
               }

               RefreshVideoFrame();
               break;


          case IDCANCEL:

               if (iOrig_ColorSpace    != MParse.Store_Flag)
                  if (iOrig_ColorSpace == STORE_YUY2)
                      Chg2YUV2(1) ;
                  else
                      Chg2RGB24(1) ;

               DestroyWindow(hLumDlg0);
               hLumDlg = NULL;
               return true;

         //   default:
         //      DestroyWindow(hLumDlg0);
         //      hLumDlg = NULL;
         //      return true;

         }
         break;



      case WM_HSCROLL:
         switch (GetWindowLong((HWND)lParam, GWL_ID))
         {
            case IDC_GAMMA_SLIDER:
               iLumGamma[iColorSpaceTab] = SendDlgItemMessage(hLumDlg0,
                                        IDC_GAMMA_SLIDER, TBM_GETPOS, 0, 0);
               Lum_SetNum_Gamma();
               break;

            case IDC_CONTRAST_SLIDER:
               iLumGain[iColorSpaceTab] = SendDlgItemMessage(hLumDlg0, 
                                         IDC_CONTRAST_SLIDER, TBM_GETPOS, 0, 0);
               Lum_SetNum_Gain();
               iLast_Y_Slider = IDC_CONTRAST_SLIDER;
               if (iLumLock_Flag)
               {
                   LumLock_Bright();
               }
               break;

            case IDC_BRIGHT_SLIDER:
               iLumOffset[iColorSpaceTab] = SendDlgItemMessage(hLumDlg0, 
                                IDC_BRIGHT_SLIDER, TBM_GETPOS, 0, 0) 
                                - 128;

               Lum_SetNum_Offset();
               iLast_Y_Slider = IDC_BRIGHT_SLIDER;
               if (iLumLock_Flag)
               {
                   LumLock_Gain();
               }
               break;


            case IDC_SAT_SLIDER:
               iSatGain[iColorSpaceTab] = SendDlgItemMessage(hLumDlg0, 
                                         IDC_SAT_SLIDER, TBM_GETPOS, 0, 0);
               Lum_SetNum_Sat();
               break;

            case IDC_BLUE_SLIDER:
               iSatAdd_U = SendDlgItemMessage(hLumDlg0,
                                        IDC_BLUE_SLIDER, TBM_GETPOS, 0, 0);

               Lum_SetNum_Blue();

               iLast_UV_Slider = IDC_BLUE_SLIDER;
               if (iSatLock_Flag)
                    SatLock_Red();
               break;

            case IDC_RED_SLIDER:
               iSatAdd_V = SendDlgItemMessage(hLumDlg0,
                                        IDC_RED_SLIDER, TBM_GETPOS, 0, 0);

               Lum_SetNum_Red();
               iLast_UV_Slider = IDC_RED_SLIDER;
               if (iSatLock_Flag)
                    SatLock_Blue();
               break;
         }

         RefreshVideoFrame();
         break;

   }
   return false;
}


