
#include "global.h"

#if defined WIN32 || defined _WIN32

#include <string.h>
#include <errno.h>
#define VERSION_STRING "\n WAVE_OUT 0.7.1_rj\n"
#endif
 
#include "wave_out.h"
#include "Wave_CS.h"

//-----------------------------------------------------------------
/*
 *  This function registers already played WAVE chunks. 
                      Freeing is done by WAV_Free_Memory(),
 */

static void CALLBACK
wave_callback ( HWAVE hWave, UINT uMsg, DWORD dwInstance, DWORD dwParam1, DWORD dwParam2 )
{
  if ( uMsg == WOM_DONE ) 
  {
    EnterCriticalSection ( &WAV_Critical_Section );
    PlayedWaveHeaders [PlayedWaveHeadersCount++] = (WAVEHDR*) dwParam1;
    LeaveCriticalSection ( &WAV_Critical_Section );

    if (DBGflag)
    {
       sprintf(szBuffer, "    *PLAYED* Aud=%d    Done=%d", iWAVEOUT_Scheduled_Blocks, PlayedWaveHeadersCount);
       DBGout(szBuffer);
    }
    if (DBGflag || iAudioDBG)     //if (iAudState != '*')
    {
      if (PlayedWaveHeadersCount >= iWAVEOUT_Scheduled_Blocks)
      {
          iAudState = '-';
          TextOut(hDC, 0, iMsgPosY, "--------------------", 20);
      }
    }
    

  }
}



/*static */ void
WAV_Free_Memory ( void )
{
  WAVEHDR*  wh;
  HGLOBAL   hg;

  EnterCriticalSection ( &WAV_Critical_Section );

  wh = PlayedWaveHeaders [--PlayedWaveHeadersCount];
  iWAVEOUT_Scheduled_Blocks--;                   // decrease the number of USED blocks

  LeaveCriticalSection ( &WAV_Critical_Section );

  waveOutUnprepareHeader ( hWAVEdev, wh, sizeof (WAVEHDR) );

  hg = GlobalHandle ( wh -> lpData );   // Deallocate the buffer memory
  GlobalUnlock (hg);
  GlobalFree   (hg);

  hg = GlobalHandle ( wh );             // Deallocate the header memory
  GlobalUnlock (hg);
  GlobalFree   (hg);

  process.iWavQue_Len -= iWavBlock_Len[iWavBlock_From++]; // Decrement total left to be played
  if (iWavBlock_From >= WAVEOUT_MAX_BLOCKS) iWavBlock_From = 0; // from a FIFO buffer

  if (DBGflag)
  {
      sprintf(szBuffer, "       FREE  Aud=%d    Done=%d", iWAVEOUT_Scheduled_Blocks, PlayedWaveHeadersCount);
      DBGout(szBuffer);
  }

}


//-----------------------------------------------------------------



Int WAV_Set_WIN_Parms ( FILE_T   dummyFile ,
                 Ldouble  SampleFreq,
                 Uint     BitsPerSample,
                 Uint     Channels )
{

/*
 *  extended waveform format structure used for all non-PCM formats. this
 *  structure is common to all non-PCM formats.
 
typedef struct tWAVEFORMATEX
{
    WORD        wFormatTag;         /* format type
    WORD        nChannels;          /* number of channels (i.e. mono, stereo...) 
    DWORD       nSamplesPerSec;     /* sample rate 
    DWORD       nAvgBytesPerSec;    /* for buffer estimation
    WORD        nBlockAlign;        /* block size of data 
    WORD        wBitsPerSample;     /* number of bits per sample of mono data 
    WORD        cbSize;             /* the count in bytes of the size of 
            /* extra information (after cbSize) 
} WAVEFORMATEX_t
*/ 

  WAVEFORMATEX  outFormat;
  UINT          deviceID = WAVE_MAPPER;
  int iRC;
  char szFormat[80];

  (void) dummyFile;

  iWavBlock_From = iWavBlock_To = 0;

  if ( waveOutGetNumDevs () < 1 )
    return Box ( "No audio device present.", "" );

  outFormat.wFormatTag      = WAVE_FORMAT_PCM;
  outFormat.wBitsPerSample  = (unsigned short) BitsPerSample;
  outFormat.nChannels       = (unsigned short) Channels;
  outFormat.nSamplesPerSec  = (unsigned long)(SampleFreq + 0.5);
  outFormat.nBlockAlign     = (unsigned short)((outFormat.wBitsPerSample 
                                      + 7) / 8 * outFormat.nChannels);
  outFormat.nAvgBytesPerSec = outFormat.nSamplesPerSec * outFormat.nBlockAlign;

//  sprintf(szFormat, "%hu", outFormat.nSamplesPerSec) ;
//  SetDlgItemText(hStats, IDC_SAMPLE_RATE, szFormat);
//  sprintf(szFormat, "%hu", outFormat.wBitsPerSample) ;
//  SetDlgItemText(hStats, IDC_SAMPLE_DEPTH, szFormat);
//  sprintf(szFormat, "%hu", outFormat.nChannels) ;
//  SetDlgItemText(hStats, STATS_AUDIO_CHANNELS, szFormat);
  WAV_Fmt_Flag = 1;
  sprintf(WAV_Fmt_Brief, "%hu %hu %hu", outFormat.nSamplesPerSec, 
                            outFormat.wBitsPerSample, outFormat.nChannels);

  // FUDGE - TRAP SUSPICIOUS SETTINGS

  //  no longer be necessary
  //if (outFormat.nChannels < 2)     // && outFormat.nSamplesPerSec == 48000 &
  //    outFormat.nChannels = 2;

  if (outFormat.nSamplesPerSec <    1000
   || outFormat.nSamplesPerSec > 1024000)
  {
      outFormat.nSamplesPerSec =   48000;
      outFormat.nChannels = 2;
  }

  if (outFormat.nSamplesPerSec ==  48000 && iAudio_Force44K)
      outFormat.nSamplesPerSec =   44100;


  if (outFormat.nAvgBytesPerSec <    1000
   || outFormat.nAvgBytesPerSec > 8192000)
      outFormat.nAvgBytesPerSec = 1024000;

  if (outFormat.wBitsPerSample !=  8
   && outFormat.wBitsPerSample != 16
   && outFormat.wBitsPerSample != 24
   && outFormat.wBitsPerSample != 32
   && outFormat.wBitsPerSample != 48
   && outFormat.wBitsPerSample != 64)
      outFormat.wBitsPerSample  = 16;

   process.iWavBytesPerMs = outFormat.nSamplesPerSec 
                          * outFormat.wBitsPerSample
                          * outFormat.nChannels / 8000 ;

   if (process.iWavBytesPerMs < 1)   // Allow for silly settings
       process.iWavBytesPerMs = 192; // 48k samples/sec


   iRC = waveOutOpen ( &hWAVEdev, deviceID, &outFormat, (DWORD)wave_callback, 0, CALLBACK_FUNCTION );
   if (iRC != MMSYSERR_NOERROR)
   {
      sprintf(szFormat, "Format=%d Bits=%u Ch=%u Freq=%d/s Align=%d AvgBps=%d",
              outFormat.wFormatTag, BitsPerSample,   
                                      Channels, outFormat.nSamplesPerSec,
                   (int)(outFormat.nBlockAlign), outFormat.nAvgBytesPerSec);
      wav_MM_ERR(iRC, &szFormat[0]);

    /*switch ( iRC )
    {
      case MMSYSERR_ALLOCATED:   return Box ( "Device is already open.", szFormat);
      case MMSYSERR_BADDEVICEID: return Box ( "The specified device is out of range.", szFormat);
      case MMSYSERR_NODRIVER:    return Box ( "There is no audio driver in this system.", szFormat );
      case MMSYSERR_NOMEM:       return Box ( "Unable to allocate sound memory.", szFormat );
      case WAVERR_BADFORMAT:     return Box ( "This audio format is not supported.", szFormat );
      case WAVERR_SYNC:          return Box ( "The device is synchronous.", szFormat );
      default:                   return Box ( "Unknown media error.", szFormat );
    }*/

    iPlayAudio=0;
    iAudio_Lock = 0;
  }
  else 
  if (iPlayAudio)
  {
      iWAV_Init = 1;
      waveOutReset ( hWAVEdev );
      if (iPlayAudio)
      {
         InitializeCriticalSection ( &WAV_Critical_Section );
         WAV_cs_FLAG = 1;
         SetPriorityClass ( GetCurrentProcess (), HIGH_PRIORITY_CLASS );
         return 0;
      }
  }

  return -1;
}


