
#include "windows.h"
#include "WINUSER.H"
#include "global.h"
#include "Buttons.h"
#define true 1
#define false 0
#include <commctrl.h>


HWND  hStop,  hPlayP, hSingle, 
      hSlower, hFaster,
      hSlow1, hSlow2, hFast1, hFast2;

HWND  hBack1,  hBack2, hBack3, hBack4,  
      hFwd1,   hFwd2,  hFwd3,  hFwd4; 

int iPlayP_PosX, iStop_PosX,  iSingle_PosX;
int iSlow1_PosX, iSlow2_PosX, iSlower_PosX;
int iFast1_PosX, iFast2_PosX, iFaster_PosX, iFastX_PosX;

#define SPACER 2
//int iToolPosX[15]
int iLum_PosX, iZoom_PosX, iAddB_PosX;
int iTrackBar_PosX;

int iMarkL_PosX, iBack1_PosX, iBack2_PosX, iBack3_PosX, iBack4_PosX;
int iMarkR_PosX, iFwd1_PosX,  iFwd2_PosX,  iFwd3_PosX,  iFwd4_PosX;



// TTM_SETDELAYTIME
void CreateToolTip(HWND hWnd, LPSTR strTT)
{
  RECT rect;
  LPTSTR lptstr = strTT;
  HWND hWndTT;
  TOOLINFO ti;


  hWndTT = CreateWindowEx(WS_EX_TOPMOST,TOOLTIPS_CLASS,NULL,
                        WS_POPUP | TTS_NOPREFIX,CW_USEDEFAULT,CW_USEDEFAULT,
                        CW_USEDEFAULT,CW_USEDEFAULT,hWnd,NULL,hInst,NULL);
                
  if (hWndTT)
  {                       
      ti.cbSize = sizeof(TOOLINFO);
      ti.uFlags = TTF_SUBCLASS;
      ti.hwnd = hWnd;
      ti.hinst = hInst;
      ti.uId = 0;
      ti.lpszText = lptstr;


      GetClientRect(hWnd, &rect);
      ti.rect.left = rect.left;
      ti.rect.top = rect.top;
      ti.rect.right = rect.right;
      ti.rect.bottom = rect.bottom;

      SendMessage(hWndTT, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
  }
}



HWND TB_Create(char *P_lpszDesc,   // int P_DISABLED,
                           int P_iX, 
                           int P_iY,
                         HMENU P_uNumber)
{
  HWND hHandle;
  hHandle = CreateWindow("BUTTON", 
               P_lpszDesc,

                           // BS_ICON | 
               // P_DISABLED  | 
               WS_CHILD | WS_VISIBLE | WS_DLGFRAME,

               P_iX, P_iY,
                           iTool_Wd, iTool_Ht,
                           hWnd_MAIN, 
               P_uNumber, 
                           hInst, NULL);

  if (hFont1)
    SendMessage(hHandle, WM_SETFONT, (WPARAM)(hFont1), 0);

  return hHandle;

}


//-----------------------------------------------


void PlayTool_Metrics()
{

  int iAllow; //, iTmp1;
  
  iAllow = 13;

  iStop_PosX   = (iTool_Wd * 5) - 7;  // 4*Number of buttons)+1 in shortest toolbar 

  if (iSkipBar_PosY) // Stacked ?
  {
     iStop_PosX   = iToolbarWidth - iMEDIUMBAR_WIDTH; // -7; // + (iTool_Wd / 2); //((15 * iTool_Wd) / 2); // iMarkL_PosX;
     iMarkL_PosX  = iStop_PosX;
     //iSingle_PosX = iStop_PosX + iTool_Wd;
     //iSlow1_PosX  = iSingle_PosX + iTool_Wd;
     //iPlayP_PosX  = iSlow1_PosX + iTool_Wd;
  }
  else
  //if (iTrackbar_Big)
  {
     // iStop_PosX  = iToolbarWidth - (iMEDIUMBAR_WIDTH * 2); // ((41 * iTool_Wd)/2); // 33 = 2*Number of left hand buttons + 1
     //if (iToolbarWidth > (iTool_Wd * 26))
     //    iStop_PosX -= (iTool_Wd + 9);
     //iTmp1 = iTool_Wd * 20 / 2; // (2*Number of buttons) in MARK/SKIP toolbar
     iMarkL_PosX  = iToolbarWidth - iMEDIUMBAR_WIDTH; // - 6;  //iTmp1;
  }
  //else
  //{
  //   iStop_PosX  = iToolbarWidth - ( 11 * iTool_Wd);
  //   iPlayP_PosX  = iStop_PosX + iTool_Wd;
  //}

  iSingle_PosX = iStop_PosX    + iTool_Wd + SPACER;
  iSlow2_PosX  = iSingle_PosX  + iTool_Wd;
  iSlow1_PosX  = iSlow2_PosX   + iTool_Wd;
  iSlower_PosX = iSlow1_PosX   + iTool_Wd;
  iPlayP_PosX  = iSlower_PosX  + iTool_Wd + SPACER;

  iFaster_PosX  = iPlayP_PosX  + iTool_Wd + SPACER;
  iFast1_PosX   = iFaster_PosX + iTool_Wd;
  iFast2_PosX   = iFast1_PosX  + iTool_Wd;
  iFastX_PosX   = iFast2_PosX  + iTool_Wd + SPACER;


  iBack1_PosX    = iMarkL_PosX + iTool_Wd + SPACER;
  iBack2_PosX    = iBack1_PosX + iTool_Wd;
  iBack3_PosX    = iBack2_PosX + iTool_Wd; 
  iBack4_PosX    = iBack3_PosX + iTool_Wd; 

  iFwd4_PosX    = iBack4_PosX  + iTool_Wd + SPACER; // + SPACER;
  iFwd3_PosX    = iFwd4_PosX   + iTool_Wd;
  iFwd2_PosX    = iFwd3_PosX   + iTool_Wd;
  iFwd1_PosX    = iFwd2_PosX   + iTool_Wd;
  iMarkR_PosX   = iFwd1_PosX   + iTool_Wd + SPACER;

}




void PlayTools_Create() // Extra buttons for special playback
{
  PlayTool_Metrics();

  hSingle = TB_Create(&"/",  iSingle_PosX, iPlayBar_PosY, (HMENU) ID_FWD_FRAME);

  hSlower = TB_Create(&"p-", iSlower_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_SLOWER);
  hFaster = TB_Create(&"p+", iFaster_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_FASTER);

  hSlow1  = TB_Create(&"s",  iSlow1_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_SLOW_1);
  hSlow2  = TB_Create(&"S",  iSlow2_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_SLOW_2A);
  hFast1  = TB_Create(&"f",  iFast1_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_FAST_1);
  hFast2  = TB_Create(&"FF", iFast2_PosX, iPlayBar_PosY, (HMENU) IDM_PLAY_FAST_2);

  hFastX  = TB_Create(&"*",  iFastX_PosX, iPlayBar_PosY, (HMENU) ID_CUE_FWD);

  if (iCtl_ToolTips)
  {
     CreateToolTip(hSingle, " SINGLE Frame Advance ");
     CreateToolTip(hSlower,  " Play SLOWER");
     CreateToolTip(hFaster,  " Play FASTER");
     CreateToolTip(hSlow1,  " Play SLOW -33%");
     CreateToolTip(hSlow2,  " Play SLOW -50%");
     CreateToolTip(hFast1,  " Play FAST +50%");
     CreateToolTip(hFast2,  " Play FAST +100%");
     CreateToolTip(hFastX,  " PLAY EXTRA FAST");
  }
}



//----------------------------------------------------------------

void DSP_ButtonFont_Sizing()  // Scale button size to screen res
{
  unsigned int uTmp1;

  iTool_Wd  = (VGA_Height * 30) / 600;  // 
  iTool_Ht  = iTool_Wd + 4;

  // For High-Res display, scale the font to make it readable
  if (VGA_Height <= 600)
     hFont1 = 0;
  else
  {
     uTmp1 = iTool_Wd - 2;
     if (iCtl_Readability)
       uTmp1 = uTmp1 * 6 / 10;
     else
       uTmp1 = uTmp1 / 2;

     hFont1 = CreateFont( 
                               uTmp1,    // logical height of font 
                                   0,    // logical average character width 
                                   0,    // angle of escapement 
                                   0,    // base-line orientation angle 
                                 400,    // font weight 
                                   0,    // italic attribute flag 
                                   0,    // underline attribute flag 
                                   0,    // strikeout attribute flag 
                        ANSI_CHARSET,    // character set identifier 
                  OUT_DEFAULT_PRECIS,    // output precision 
                 CLIP_DEFAULT_PRECIS,    // clipping precision 
                 CLIP_DEFAULT_PRECIS,    // output quality 
      (DEFAULT_PITCH || FF_DONTCARE),    // pitch and family 
           &"Arial"   //  &"Verdana"     // pointer to typeface name string 
                                   );   

    //SendMessage(hMenu, WM_SETFONT, (WPARAM)(hFont1), MAKELPARAM(TRUE, 0));

  }
}




void D501_RESET_MainWindow()
{
  if (DBGflag)
  {
    DBGout("D501_RESET");
  }

   D500_ResizeMainWindow(iDUALBAR_WIDTH,  // iMIN_FULLBAR_WIDTH, 
                         MIN_OVL_HEIGHT, 1);
}




//-------------------------------------------------------------------
void D500_ResizeMainWindow(int P_Width, int P_Height, int P_Full)
{

  int iWindow_Mode;

  if (DBGflag)
      DBGout("D500_RESIZE");

  if (IsIconic(hWnd_MAIN))
    return;

  GetWindowRect(hWnd_MAIN, &wrect);
  GetClientRect(hWnd_MAIN, &crect);
  Edge_Width  = wrect.right  - wrect.left - crect.right;
  Edge_Height = wrect.bottom - wrect.top  - crect.bottom;
  iMenuHeight = crect.top - wrect.top;
  if (iMenuHeight < 0) iMenuHeight = - iMenuHeight;

  //Edge_Width  = GetSystemMetrics(SM_CXBORDER);
  //Edge_Height = GetSystemMetrics(SM_CYBORDER);

  if (iMainWin_State > 0)
     iWindow_Mode = SW_SHOWMAXIMIZED; // 0;
  else
     iWindow_Mode = 0;

  if (MParse.SystemStream_Flag < 0
  &&  Overlay_Width  >= P_Width 
  &&  Overlay_Height >= P_Height)
  {
      if (DBGflag)
          DBGout("   SKIPPED");

      return;
  }
    

  Overlay_Width  = P_Width ;
  Overlay_Height = P_Height ;



  //if (Overlay_Width  > VGA_Width ) Overlay_Width   = VGA_Width ;
  //if (Overlay_Height > VGA_Height) Overlay_Height = VGA_Height;

  if (Overlay_Width  > (VGA_Width - Edge_Width) )
  {
      Overlay_Width   = VGA_Width ;
      if (Prev_Coded_Width == 0)
         iWindow_Mode = SW_SHOWMAXIMIZED ;
  }


  ToolBar_Metrics();

  
  if (DBGflag)
  {
    sprintf(szDBGln, "RESIZE=%d.%d  W=%d.%d  C=%d.%d  O=%d.%d  T=%d.%d",
                     Overlay_Width, Overlay_Height,
                     wrect.right, wrect.bottom,
                     crect.right, crect.bottom,
                     Overlay_Width, Overlay_Height,
                     iToolbarWidth, iTool_Wd);
    DBGout(szDBGln);
  }


  //if (Overlay_Height > MIN_OVL_HEIGHT && iView_Aspect_Mode)
  //    Client_Height = Overlay_Height * iAspVert / 2048 + Edge_Height;
  // else
        Client_Height = Overlay_Height + Edge_Height;


  if (Client_Height > iViewMax_Height)
  {
      Client_Height = iViewMax_Height;
      //if (Prev_Coded_Width == 0)
      iWindow_Mode = SW_SHOWMAXIMIZED;
  }

  Client_Height += iTopMargin;



  if (Overlay_Width < iToolbarWidth)
      Client_Width  = iToolbarWidth;
  else
      Client_Width  = Overlay_Width;

  Client_Width = Client_Width + Edge_Width;


  if (iViewToolBar)
  {
    //MoveWindow(hOpenButton,    0, 0,
    //                              iTool_Wd, iTool_Ht, true);
    MoveWindow(hBmpButton,  0,            0,   iTool_Wd, iTool_Ht, true);
    MoveWindow(hAddButton,  iTool_Wd,     0,   iTool_Wd, iTool_Ht, true);
    MoveWindow(hLumButton,  iLum_PosX,    0,   iTool_Wd, iTool_Ht, true);
    MoveWindow(hZoomButton, iZoom_PosX,   0,   iTool_Wd, iTool_Ht, true);

    MoveWindow(hTrack,     iTrackBar_PosX, iTrackBar_PosY, iTrack_Wd, iTool_Wd, true);

    MoveWindow(hMarkLeft,  iMarkL_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hBack4,     iBack4_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hBack3,     iBack3_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hBack2,     iBack2_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hBack1,     iBack1_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hFwd1,      iFwd1_PosX,   iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hFwd2,      iFwd2_PosX,   iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hFwd3,      iFwd3_PosX,   iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hFwd4,      iFwd4_PosX,   iSkipBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hMarkRight, iMarkR_PosX,  iSkipBar_PosY, iTool_Wd, iTool_Ht, true);

    //MoveWindow(hMsgTxt,      0,           iTool_Wd, iToolPosX[4], iTool_Wd,  true);
    //MoveWindow(hTimeTxt,     iMarkL_PosX, iTool_Wd, iTrackBar_PosX, iTool_Wd,  true);

    MoveWindow(hStop,   iStop_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
    MoveWindow(hPlayP,  iPlayP_PosX, iPlayBar_PosY, iTool_Wd, iTool_Ht, true);

    
    //if (iTrackbar_Big)
    {
       //if (!hFastX)
       //{
       //  PlayTools_Create();
       //}
       MoveWindow(hSingle, iSingle_PosX, iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hSlow1,  iSlow1_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hSlow2,  iSlow2_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hSlower, iSlower_PosX, iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hFaster, iFaster_PosX, iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hFast1,  iFast1_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hFast2,  iFast2_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
       MoveWindow(hFastX,  iFastX_PosX,  iPlayBar_PosY, iTool_Wd, iTool_Ht, true);
    }
    

  }


  if (P_Full || MParse.Stop_Flag || MParse.Pause_Flag)
  {
    if (!iMainWin_State)
    {

      MoveWindow(hWnd_MAIN, wrect.left, wrect.top,
                     Client_Width, Client_Height, true);
  
      Calc_PhysView_Size();
      if (DBGflag)
      {
        sprintf(szDBGln, "              NEW CLIENT=%d.%d",
                    Client_Width, Client_Height);
        DBGout(szDBGln);
      }
    }
    /*
    else
    {
       WINDOWPLACEMENT.length = sizeof(WINDOWPLACEMENT);
       WINDOWPLACEMENT.showCmd = SW_SHOWMAXIMIZED;
       SetWindowPlacement(hWnd,
                 WINDOWPLACEMENT *lpwndpl // address of structure with position data
                          )
    }
    */

    //SetRect(&orect, 0, 0,  Client_Width, Client_Height);
    if (iMsgLife > 0)
        DSP1_Main_MSG(1,0);

  }
 
   //if (iWindow_Mode)
   //{
   //      ShowWindow(hWnd, iWindow_Mode);
   //}

/*
  if (DBGflag)
  {
    sprintf(szDBGln, "Window=%d.%d  Max=%d  Full=%d\n",
             Client_Width, Client_Height, iWindow_Mode, P_Full);
    DBGout(szDBGln);
  }
*/

}



//--------------------------------------------------------------
void ToolBar_Metrics()
{

  int iTrue_Width, iTmp1;
  //Calculate and store the position of each control

  //int iEdge2;
  //iEdge2 = Edge_Width<<1;
  //if (iEdge2 < 1) iEdge2 = 4;

  if (VGA_Height < 480)
      VGA_Height = 480;

  DSP_ButtonFont_Sizing();    // Scale button size to screen res
   
  iMIN_FULLBAR_WIDTH = 26 * iTool_Wd;
  iMEDIUMBAR_WIDTH   = 10 * iTool_Wd + 7;
  iDUALBAR_WIDTH     = 15 * iTool_Wd + 7;
  iSTACKBAR_WIDTH    = 19 * iTool_Wd;

  iPlayBar_PosY = 0;  iSkipBar_PosY = 0;

  if (Overlay_Width  < iTool_Wd)  // Nothing loaded ?
      Overlay_Width  = iDUALBAR_WIDTH;

  // Calc positions of Left-Hand buttons
  iAddB_PosX = iTool_Wd;
  iLum_PosX  = iAddB_PosX + iTool_Wd;
  iZoom_PosX = iLum_PosX  + iTool_Wd;
  //iSelMsgX   = iZoom_PosX * 2;   // [3] + 15;


  // Trackbar Defaults
  iTrackbar_Big  = iCtl_Trackbar_Big; // && (File_Limit || iMainWin_State > 0);
  iTrack_Wd      = iToolbarWidth;
  iTrackBar_PosY = iTool_Ht;
  iTrackBar_PosX = 0;                             // Trackbar

  if (! iViewToolBar)
  {
    if (iAspect_Height > (VGA_Height - 70)
    //||  iMainWin_State > 0
       )
        iTopMargin   = 1;
    else
        iTopMargin   = 24;
  }
  else
  {
    iTopMargin   = iTool_Ht * 8 / 5; // Should really interrogate Text Height    
  }


  iToolButton_Cnt = 15;

  // Calc positions of Left-Hand buttons and Trackbar


  if (iMainWin_State == 0)
      iTrue_Width = Overlay_Width;
  else
      iTrue_Width = VGA_Width;

  if (iTrue_Width  < iMIN_FULLBAR_WIDTH)
  {
      if (! iViewToolBar)
         iMsgPosY    = 1;
      else
      {
         iToolbarWidth  = iMIN_FULLBAR_WIDTH; 
         iTopMargin     = iTopMargin + iTool_Ht;

         iMsgPosY    = iTool_Ht * 2; // iLum_PosX;
         if (iTrue_Width  <= iSTACKBAR_WIDTH) // Stack trigger point
         {   // Stack the toolbars vertically
             if (iTrue_Width <= iDUALBAR_WIDTH)   
                 iTmp1        = iDUALBAR_WIDTH;  // Width of first 2 toolbars
             else
                 iTmp1        = iSTACKBAR_WIDTH; // A little wider than SD compact display

             iToolbarWidth   = iTmp1;
             //iPlayBar_PosY   = iTool_Ht; 
             iSkipBar_PosY   = iTool_Ht;
             iTrackBar_PosY  = iTool_Ht * 2; //iLum_PosX;  
             //iSelMsgX       = 0;
             iMsgPosY        = iTool_Ht * 3;
             iTopMargin     += iTool_Ht;
         }
      }

      if (iTrue_Width <= iToolbarWidth)
          iTrue_Width  = iToolbarWidth + 2; //iMIN_FULLBAR_WIDTH * 2 / 3;

      iTrackbar_Big  = 1;
      iTrackBar_PosX   = 0;                            // Trackbar
      //iToolPosX[4]   = iZoom_PosX + iLum_PosX;  // Message Text (NOT IMPLEMENTED)
  }
  else
  {   // Wider than minimum
      iToolbarWidth  = iMIN_FULLBAR_WIDTH; 
      if (iTrue_Width > iToolbarWidth)
      {
         if (iTrue_Width < VGA_Width)
             iToolbarWidth = iTrue_Width ;//- iEdge2;
         else
             iToolbarWidth = VGA_Width - 1;//- iEdge2;
      }

      if (iViewToolBar)
      {
        //if (iTrackbar_Big)
        {
           iTopMargin += iTool_Ht;
           iTrack_Wd   = iToolbarWidth;
        }
        //else
        //{  // Trackbar squeezed into same line as Toolbar
        //   iTrackBar_PosY = 0;
        //   iTrackBar_PosX   = iZoom_PosX  + iTool_Wd;      // Trackbar
        //   iTrack_Wd      = iToolbarWidth -(iTool_Wd * iToolButton_Cnt);
        //}
      }

      //iToolPosX[4]   = iTrackBar_PosX + iLum_PosX;  // Message Text (NOT IMPLEMENTED)

      if (! iViewToolBar)
         iMsgPosY    = 1;
      else
         iMsgPosY    = iTopMargin - 24; // iTool_Ht;

      //iSelMsgX       = iZoom_PosX + 45;   // [3] + 15;

  }

  if (Overlay_Height < MIN_OVL_HEIGHT)
      Overlay_Height = MIN_OVL_HEIGHT;

  iTrack_Wd      = iToolbarWidth;


  // Calc positions of Right-Hand buttons

  PlayTool_Metrics();

  if (iSkipBar_PosY)
      iSelMsgX   = iStop_PosX;
  else
      iSelMsgX   = iSingle_PosX;

  iTimeX = iToolbarWidth - (7 * iTool_Wd); // iMarkL_PosX - 15;
  if (iTimeX < 0)
      iTimeX = 0;

  if (iTrue_Width >= iMIN_FULLBAR_WIDTH)  // 480 // (iAspect_Width >= 640)
  {
      iTimeY = iMsgPosY; //iTool_Ht;
  }
  else
  {
     // iTimeX = iToolPosX[4] - 20;// - iTool_Wd;
     iTimeY = iTopMargin;
     iTopMargin = iTopMargin + 24; // = iTopMargin<<1;
  }

  iViewMax_Height  = VGA_Height - crect.top + wrect.top
                                -  iTopMargin;


}




//-------------------


void  CreateToolTips_ALL()
{
   CreateToolTip(hBmpButton, " BMP Snapshot ");
   CreateToolTip(hAddButton, " ADD Selection to Clip List ");

   CreateToolTip(hStop,   " STOP ");
   CreateToolTip(hPlayP,   " PLAY ");

   CreateToolTip(hMarkLeft,  " MARK START of Clip ");
   CreateToolTip(hMarkRight, " MARK END of Clip ");


   CreateToolTip(hLumButton, " LUMINANCE Display Adjustment (Gamma) ");
   CreateToolTip(hZoomButton, " ZOOM ");


   //if (iCtl_KB_NavOpt)
   {
      CreateToolTip(hBack1,  " STEP BACK 1 GOP  (Previous I-Frame) ");
      CreateToolTip(hFwd1, " STEP Forward 1 GOP  (Next I-Frame) ");

      CreateToolTip(hBack2,  " JUMP BACK ");
      CreateToolTip(hFwd2, " JUMP Forward");

      CreateToolTip(hBack3,  " JUMP Back MORE");
      CreateToolTip(hFwd3, " JUMP Forward MORE");

      CreateToolTip(hBack4,  " JUMP Back LOTS");
      CreateToolTip(hFwd4, " JUMP Forward LOTS");
   }
   //else
   //{
   //   CreateToolTip(hBack1,  " JUMP BACK ");
   //   CreateToolTip(hFwd1, " JUMP Forward ");

   //   CreateToolTip(hBack2,  " STEP BACK 1 GOP  (Previous I-Frame) ");
   //   CreateToolTip(hFwd2, " STEP Forward 1 GOP  (Next I-Frame) ");
   //}

}



void DSP_Button_Abbr()
{
   // Key Assigment Options also impact button order
   // Because they are linked via the accelerator

   if (iCtl_KB_NavOpt)       // Approximate VDUB
   {
      hABack1 = (HMENU) ID_LEFT_ARROW;
      hABack2 = (HMENU) ID_LEFT_SHIFT;
      hABack3 = (HMENU) ID_UP_ARROW;
      hABack4 = (HMENU) ID_UP_SHIFT;
      hAFwd1  = (HMENU) ID_RIGHT_ARROW;
      hAFwd2  = (HMENU) ID_RIGHT_SHIFT;
      hAFwd3  = (HMENU) ID_DOWN_ARROW;
      hAFwd4  = (HMENU) ID_DOWN_SHIFT;
     /*
      strcpy(szAbbr1, "<<"); // "") ;
      strcpy(szAbbr2, "<") ;
      strcpy(szAbbr3, ">") ;
      strcpy(szAbbr4, ">>"); // "") ;
      strcpy(szAbbr5, "");  
      strcpy(szAbbr6, "");  
      */
   }
   else
   {                         // Original DVD2AVI keys
      hABack1 = (HMENU) ID_DOWN_ARROW;
      hABack2 = (HMENU) ID_DOWN_SHIFT;
      hABack3 = (HMENU) ID_LEFT_ARROW;
      hABack4 = (HMENU) ID_LEFT_SHIFT;
      hAFwd1  = (HMENU) ID_UP_ARROW;
      hAFwd2  = (HMENU) ID_UP_SHIFT;    
      hAFwd3  = (HMENU) ID_RIGHT_ARROW;
      hAFwd4  = (HMENU) ID_RIGHT_SHIFT;
     /*
      strcpy(szAbbr1, "") ;
      strcpy(szAbbr2, "<<"); // "") ;
      strcpy(szAbbr3, ">>"); // "") ;
      strcpy(szAbbr4, "") ;
      strcpy(szAbbr5, ">"); 
      strcpy(szAbbr6, "<");
     */
   }
}


//--------------------------------------

void ToolBar_Destroy()
{
  iViewToolBar = 0;
  DestroyWindow(hBmpButton);
  DestroyWindow(hAddButton);
  DestroyWindow(hLumButton);
  DestroyWindow(hZoomButton);

  DestroyWindow(hTrack);

  DestroyWindow(hStop);
  DestroyWindow(hPlayP);

  //if (hFastX)  
  //{
    DestroyWindow(hFastX);    
    DestroyWindow(hFaster);   DestroyWindow(hSlower);
    DestroyWindow(hFast1);    DestroyWindow(hFast2);
    DestroyWindow(hSlow1);    DestroyWindow(hSlow2);
    DestroyWindow(hSingle);
  //}

  DestroyWindow(hMarkLeft);
  DestroyWindow(hBack4);
  DestroyWindow(hBack3);
  DestroyWindow(hBack2);
  DestroyWindow(hBack1);
  DestroyWindow(hFwd1);
  DestroyWindow(hFwd2);
  DestroyWindow(hFwd3);
  DestroyWindow(hFwd4);
  DestroyWindow(hMarkRight);

  hFastX = 0;
}




//--------------------------------------

//--------------------------------------

void BmpButton_Create()
{
  HANDLE hImg;

  hBmpButton = TB_Create(&"B", // WS_DISABLED,
                          0, 0, 
                         (HMENU) IDM_BMP_ASIS);

  /*
#define OIC_BANG            32515
  // iTemp[0] = OIC_BANG;

  hImg     = LoadImage(0,    // NULL,   // hInst,
                      IDI_HAND, // OIC_BANG,// (char*)(&iTemp[0]), // MAKEINTRESOURCE(IDI_SNAP),
                      IMAGE_ICON,
                      0,0,0);

  SendMessage(hBmpButton, BM_SETIMAGE,
              (WPARAM)IMAGE_ICON,
              (LPARAM)hImg);
  */
  
}



//--------------------------------------

void AddButton_Create()
{
  hAddButton = TB_Create(&"+", // WS_DISABLED, 
                                 iTool_Wd, 0, 
                                  (HMENU) IDM_CLIP_ADD);

}



//--------------------------------------

void MarkLeftButton_Create()
{
   hMarkLeft = TB_Create(&"[", // WS_DISABLED,
               iMarkL_PosX, iSkipBar_PosY, 
               (HMENU) ID_FROM_MARK);
}



//--------------------------------------

void MarkRightButton_Create()
{
   hMarkRight = TB_Create(&"]", // WS_DISABLED, 
               iMarkR_PosX, iSkipBar_PosY, (HMENU) ID_TO_MARK);

}



//--------------------------------------

void ToolBar_Create()
{
  iViewToolBar = 1;

  BmpButton_Create();
  
  AddButton_Create();

  hLumButton = TB_Create(&"L",  // 0, 
               iLum_PosX, 0, (HMENU) IDM_LUMINANCE);

  hZoomButton = TB_Create(&"Z", //  /* WS_DISABLED*/ 0,
               iZoom_PosX, 0, 
                (HMENU) IDM_ZOOM);

  
  //iTemp[0] = OBM_ZOOM;
  //SendMessage(hBmpButton, BM_SETIMAGE,
  //                       /* (WPARAM)*/ IMAGE_BITMAP,

                         /*
                         (LPARAM)LoadBitmap(hInst, 
                                           MAKEINTRESOURCE(IMG_BITMAP)) 
                         */
                         /*
                         (LPARAM)LoadImage(NULL,  // hInst,
                                           (char*)(&iTemp[0]),
                                           IMAGE_BITMAP ,0,0,0) */
 //            );
  



  hTrack = CreateWindow(TRACKBAR_CLASS, NULL,
                WS_CHILD | WS_VISIBLE
                              // | WS_DISABLED
                              // | TBS_NOTICKS  | TBS_TOP
                                 | TBS_ENABLESELRANGE,
                     iTrackBar_PosX, iTrackBar_PosY, 
                     iTrack_Wd,    iTool_Wd,
                     hWnd_MAIN, (HMENU) ID_TRACKBAR, hInst, NULL);

  SendMessage(hTrack, TBM_SETRANGE, (WPARAM) true,
                        (LPARAM) MAKELONG(0, TRACK_PITCH));
  if (process.total)
      T100_Upd_Posn_Info(0);

  // More buttons on Right Hand side of trackbar

  hStop = TB_Create(&"", // WS_DISABLED,  // STOP Lozenge
               iStop_PosX, iPlayBar_PosY,   
               (HMENU) IDM_STOP);

  hPlayP = TB_Create(&"P", // WS_DISABLED,
               iPlayP_PosX, iPlayBar_PosY,  
               (HMENU) IDM_PLAY_HERE);

  
  //if (iTrackbar_Big)
  {
      PlayTools_Create();
  }
  


  MarkLeftButton_Create();

  // hPrevFile = TB_Create(&"|<",
  //           iToolPosX[??],  iSkipBar_PosY, 
  //           (HMENU) ID_LEFT_CTRL);

  hBack4   = TB_Create("8<", // "",
               iBack4_PosX, iSkipBar_PosY, hABack4);

  hBack3   = TB_Create("4<", //  "",
               iBack3_PosX, iSkipBar_PosY, hABack3);

  hBack2 = TB_Create("<<", // "",
               iBack2_PosX, iSkipBar_PosY, hABack2);

  hBack1 = TB_Create("<", 
               iBack1_PosX, iSkipBar_PosY,  hABack1);

  hFwd1 = TB_Create(">", 
               iFwd1_PosX, iSkipBar_PosY, hAFwd1);

  hFwd2 = TB_Create(">>", // "",
               iFwd2_PosX, iSkipBar_PosY, hAFwd2);

  hFwd3  = TB_Create(">4", //  "",
               iFwd3_PosX, iSkipBar_PosY, hAFwd3);

  hFwd4  = TB_Create(">8", // "",
               iFwd4_PosX, iSkipBar_PosY, hAFwd4);

  // hNextFile = TB_Create(&">|",
  //           iToolPosX[??],  iSkipBar_PosY, 
  //           (HMENU) ID_RIGHT_CTRL);

  MarkRightButton_Create();

  //if (File_Limit)
  //    Enable_Disable(true, 0, true);

  if (iCtl_ToolTips)
     CreateToolTips_ALL();

}



