
#include "global.h" 
#include "getbit.h"
#include "GetBit_Fast.h"
#include "AC3Dec\A53_interface.h"
#include "wave_out.h"
#include "da.h"
#include "mpalib.h"
#include "mpalib_more.h"

#define GLOBAL
#include "MpegAudio.h"




//              (RdBFR + MPEG_SEARCH_BUFSZ)
#define MPEG_PTR_BUFF_CHK                      \
while (RdPTR >= RdEOB                         \
   &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL   \
   && ! MParse.Stop_Flag )            \
{                                             \
  Mpeg_READ();                                \
  RdPTR -= MPEG_SEARCH_BUFSZ;                 \
}







#define CONV_A53_PKT_PCM       \
{                              \
  getAudio_size = 0;            \
  while (getbit_iPkt_Len_Remain > 0     \
    &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL  \
    && ! MParse.Stop_Flag && iPlayAudio)        \
  {                                     \
    if (getbit_iPkt_Len_Remain+RdPTR > RdEOB)   \
    {                    \
       if (iGot_Track_Type == FORMAT_AC3) \
          getAudio_size = ac3_decode_data(RdPTR, RdEOB-RdPTR, getAudio_size);   \
       else \
       { \
           memcpy(&AC3Dec_Buffer[getAudio_size], RdPTR, RdEOB-RdPTR);\
           getAudio_size +=  RdEOB-RdPTR;\
       } \
       \
       getbit_iPkt_Len_Remain -= RdEOB-RdPTR;    \
       Mpeg_READ();            \
       RdPTR = RdBFR;           \
    }                           \
    else                        \
    {                           \
       if (iGot_Track_Type == FORMAT_AC3) \
           getAudio_size = ac3_decode_data(RdPTR, getbit_iPkt_Len_Remain, getAudio_size);         \
       else \
       { \
           memcpy(&AC3Dec_Buffer[getAudio_size], RdPTR, getbit_iPkt_Len_Remain);\
           getAudio_size +=  getbit_iPkt_Len_Remain;\
       } \
       \
       RdPTR += getbit_iPkt_Len_Remain; \
       getbit_iPkt_Len_Remain = 0;       \
    }                   \
  }                      \
}



void Got_MPA_PayLoad();



static char *FTType[5] = {
  "48KHz", "44.1KHz", "44.1KHz", "44.1KHz", "44.1KHz"
};

/*
static char *AC3ModeDash[8] = {
  "1+1", "1_0", "2_0", "3_0", "2_1", "3_1", "2_2", "3_2"
};
*/

static unsigned char PCM_Buffer[MPEG_SEARCH_BUFSZ];
static short *ptrPCM_Buffer = (short*)PCM_Buffer;
static unsigned PCM_SamplingRate;

 
char *lpTmpMPA;
static unsigned int getbit_MPA_Track;



void GetChkPoint()
{
  unsigned int uTmp1;

  if (process.AudioPTS != PTS_NOT_FOUND)
  {
         PTS_2Field( process.AudioPTS, IDC_AUDIO_PTS);
         //memcpy(&gopTC,  &ptsTC, sizeof(ptsTC));
         memcpy(&CurrTC, &ptsTC, sizeof(ptsTC));
  }

  uTmp1 = timeGetTime();
  if (( uTmp1 - PktStats.uPrevTimeUpd) > 500)
  {
          PktStats.uPrevTimeUpd = uTmp1;
          DSP3_Main_TIME_INFO();
          Stats_FPS();
  }

  if (MParse.ShowStats_Flag)
  {
         S100_Stats_Hdr_Main(1);
         S200_Stats_Pic_Main(1);  // Keep stats relevant when Nebula clags up
  }

  if (MParse.Stop_Flag)
  {
                if (DBGflag)
                {
                  DBGout("FALL_OUT 1");
                }

            MParse.Fault_Flag = 97;
            return;
  }

}


//----------------------------------------------
// NEBULA capture routines drops video frames when CPU hits 100%,
// but audio keeps going, leaving vision jerky or frozen for duration
void Packet_Aud_Inc()
{
    getbit_MPA_Track = 0;

    PktStats.iChk_AudioPackets++;

    if (PktStats.iChk_AudioPackets > 25)
    {
      GetChkPoint();
    }
}




//---------------------------------------------

void WAV_Byte_Swap(unsigned int  uQWord_Len,
                   unsigned char *lp_IN,
                   unsigned char *p_OUT,
                   unsigned int   P_Len)
{
    unsigned char *lpConvIn0, *lpConvIn1, *lpConvEND;
    unsigned char cTMP[4];
    unsigned char *lp_OUT;

    lpConvEND = lp_IN + P_Len;
    lpConvIn0 = lp_IN;

    lp_OUT = (unsigned char*)p_OUT;

    if (uQWord_Len == 0) // 16 bits
    {
        //lpConvIn1 = lp_IN+1;
        while (lpConvIn0 < lpConvEND)
        {
               cTMP[1] =  *lpConvIn0;
               cTMP[0] =  *lpConvIn0;
               lpConvIn0 +=2;
              *(short*)lp_OUT = *(short*)&cTMP[0];
               lp_OUT    +=2;
               //lpConvIn1+=2;
        }
    }
    else
    if (uQWord_Len == 1) // 20 bits
    {
    }
    else
    if (uQWord_Len == 2) // 24 bits
    {
        lpConvIn1 = lp_IN+2;
        while (lpConvIn1 < lpConvEND)
        {
               cTMP[0] =  *lpConvIn1--;
               cTMP[1] =  *lpConvIn1--;
               cTMP[2] =  *lpConvIn1--;
              *lp_OUT++ = cTMP[0];
              *lp_OUT++ = cTMP[1];
              *lp_OUT++ = cTMP[2];
               lpConvIn1+=3;
        }
    }
}





void WAV_Packet_Warp(void *P_Buffer, int P_Len)
{
// My attempt at Judder reduction doesn't seem to be terribly effective
// so to save some CPU, you can comment out the #define

// #define JUDDER_REDUCTION
#define JUDDER_LIM 1

#ifdef JUDDER_REDUCTION
  int iTmp1, iRef1, iToCross; //, iMin;
  void *P_SrchLim, *P_EndLim, *P_EndBuf, *P_Right;
static int iBefore_Left = 0, iBefore_Right = 0;
#endif

  int iMPA_PCM_Len0, iMPA_PCM_Len1; //, iMPA_PCM_Len2;

  if (!iPlayAudio)
    return;

  iMPA_PCM_Len0 = P_Len;

  // Force subsets to quad byte boundary for 16 bit stereo

  if (MParse.FastPlay_Flag == 1)
      iMPA_PCM_Len1 = (iMPA_PCM_Len0 /  6) *  4; // 2 Thirds size // WAS: >>5) * 20;
  else
  if (MParse.FastPlay_Flag == 3)
      iMPA_PCM_Len1 = (iMPA_PCM_Len0 / 12) *  4; // 1 Third size  // WAS: >>6) * 20;
  else
  if (MParse.FastPlay_Flag == 4)
      iMPA_PCM_Len1 = (iMPA_PCM_Len0 / 16) *  4; // 1 Qtr size    // WAS: >>6) * 20;
  else
      iMPA_PCM_Len1 = (iMPA_PCM_Len0 /  8) *  4; // Halve size, 


                         /*
                         if (uMPA_ChMode_Ix == 3) // Mono Experiment
                         {
                            WAV_Byte_Swap(0, (BYTE*)fPCMData, (BYTE*)fPCMData, 
                                             iMPA_PCM_Len1);
                         }
                         */



#ifdef JUDDER_REDUCTION

  if ((MParse.FastPlay_Flag
       //&& MParse.FastPart >= 0
       && Frame_Number > 5)
  ||  MParse.SlowPlay_Flag)
  {
      if (MParse.FastPlay_Flag && iMPA_PCM_Len1 > 256)
      {
          (char*)(P_EndBuf) = (char*)(P_Buffer) + iMPA_PCM_Len0 - 4;

          // Reduce amount of judder by looking for zero crossing or low volume point

          P_SrchLim = (char*)(P_Buffer) + iMPA_PCM_Len1;
          P_EndLim  = P_Buffer;
          iRef1 =  *(short*)(P_Buffer);
          for (;;)
          {
             if (P_EndLim >= P_SrchLim)
             {
                //iAudState = ' ';
                //TextOut(hDC, 0, iMsgPosY, "// ", 2); // szBuffer, iTmp1);
                break;
             }

             iTmp1 =  *(short*)(P_EndLim);

             /*
             if ( iTmp1 > JUDDER_LIM && iTmp1 > -JUDDER_LIM)
             {

                //if (iAudState != '-')
                //{
                    iAudState = '-';
                    TextOut(hDC, 0, iMsgPosY, "-", 1); // szBuffer, iTmp1);
                //}

               P_Buffer = P_EndLim;
               break;
             }
             */

             if (iRef1 >= 0)
             {
               if ( iTmp1 <= 0)
               {
                   //iAudState = '-';
                   //TextOut(hDC, 0, iMsgPosY, "-", 1); // szBuffer, iTmp1);
                   P_Buffer = P_EndLim;
                   break;
               }
             }
             else
             {
               if ( iTmp1 > 0)
               {
                   //iAudState = '-';
                   //TextOut(hDC, 0, iMsgPosY, "-", 1); // szBuffer, iTmp1);
                   P_Buffer = P_EndLim;
                   break;
               }
             }

             (char*)(P_EndLim) += 4;
          }

          /*  SMOOTHING MAY CAUSE PROBLEMS
          // Smooth the join a little
          *(short*)(P_Buffer) = (*(short*)(P_Buffer) + iBefore_Left)  /2;
            (char*)(P_Right)  =    (char*)(P_Buffer) + 2;
          *(short*)(P_Right)  = (*(short*)(P_Right)  + iBefore_Right) /2;
          */

          // END OF SUBSET


          // Reduce amount of judder by looking for zero crossing or low volume point
          P_EndLim  = (char*)(P_Buffer) + iMPA_PCM_Len1
                       // - PlayCtl.iAudio_Warp_Accum
                         - 256;
          P_SrchLim = P_EndLim;


          iRef1 =  *(short*)(P_EndBuf);
          iTmp1 =  *(short*)(P_EndLim);
          // To match direction, may need to find an extra zero crossing
          if ((iRef1 >= 0 && iTmp1 >= 0)
          ||  (iRef1 <  0 && iTmp1 <  0))
               iToCross = 1;
          else
               iToCross = 0;

          while (P_EndLim < P_SrchLim) // P_EndBuf)
          {
             iTmp1 =  *(short*)(P_EndLim);
             /*
             if ( iTmp1 > JUDDER_LIM && iTmp1 > -JUDDER_LIM)
             {
                PlayCtl.iAudio_Warp_Accum = (char*)P_EndLim - (char*)P_SrchLim;
                iMPA_PCM_Len1 = (char*)(P_EndLim) - (char*)(P_Buffer);
                break;
             }
             */

             if (iRef1 >= 0)
             {
               if ( iTmp1 <= 0)
               {
                 if (iToCross)
                 {
                    iToCross--;
                    iRef1 = iTmp1;
                 }
                 else
                 {
                    PlayCtl.iAudio_Warp_Accum = (char*)P_EndLim - (char*)P_SrchLim;
                    iMPA_PCM_Len1 = (char*)(P_EndLim) - (char*)(P_Buffer);
                    break;
                 }
               }
             }
             else
             {
               if ( iTmp1 > 0)
               {
                 if (iToCross)
                 {
                    iToCross--;
                    iRef1 = iTmp1;
                 }
                 else
                 {
                    PlayCtl.iAudio_Warp_Accum = (char*)P_EndLim - (char*)P_SrchLim;
                    iMPA_PCM_Len1 = (char*)(P_EndLim) - (char*)(P_Buffer);
                    break;
                 }
               }
             }

             (char*)(P_EndLim) += 4;
          }
          iBefore_Left   = *(short*)(P_EndLim);
          (char*)(P_Right) = (char*)(P_EndLim) + 2;
          iBefore_Right  = *(short*)(P_Right);
      }
  }


#endif  // END JUDDER REDUCTION




  WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);


  if (MParse.SlowPlay_Flag && iPlayAudio)
  {
      WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);
      if (MParse.SlowPlay_Flag > 2 && iPlayAudio)
          WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);
  }


  if (!MParse.FastPlay_Flag && iPlayAudio)
  {
      P_Buffer = (char *)(P_Buffer) + iMPA_PCM_Len1;
      iMPA_PCM_Len1 = iMPA_PCM_Len0 - iMPA_PCM_Len1;

      WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);
      if (MParse.SlowPlay_Flag)
      {
          WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);
          if (MParse.SlowPlay_Flag > 2 && iPlayAudio)
              WAV_WIN_Play_Samples (P_Buffer, iMPA_PCM_Len1);
      }
  }

}




void GetDelay()
{
  unsigned int uVideoPTS;

  if (process.AudioPTS == PTS_NOT_FOUND
  ||  process.VideoPTS == PTS_NOT_FOUND)
  {
      //process.DelayPTS = 0; 
      //process.Delay_Calc_Flag = 1;
  }
  else
  {
    process.Delay_Calc_Flag = 0;

    // Adjust for B-frames to be displayed before I-frame
    if (process.Mpeg2_Flag)
    {

      if (gopTC.VideoPTS > process.uGOPbefore)
          uVideoPTS = gopTC.VideoPTS - process.uGOPbefore;
      else
          uVideoPTS = 0;
    }
    else
       uVideoPTS = gopTC.VideoPTS;

    if (uVideoPTS > process.AudioPTS)
    {
          process.DelayPTS = uVideoPTS - process.AudioPTS; 
          process.Delay_Sign[0] = '-';
    }
    else
    {
         process.DelayPTS = process.AudioPTS - uVideoPTS; 
         process.Delay_Sign[0] = '+';
    }

    process.Delay_ms = process.DelayPTS / 45; //90;

    if (process.Delay_ms > 10000) // Suppress if unrealistic delay
    {
       process.Delay_Sign[0] = '?';
       process.Delay_ms      = 0;    process.DelayPTS      = 0;
       process.Delay_Calc_Flag = 1;  // Try Again Later
    }
  }


}



void PTS_Audio_Analysis()
{
  if (getbit_MPA_Track == iAudio_Track_SEL)
  {
      process.AudioPTS = CandidatePTS;

      if (process.Delay_Calc_Flag)
          GetDelay();

  }


#ifdef DBG_RJ
                 if (DBGflag  && CandidatePTS > 0xFF000000)
                 {
                     sprintf(szBuffer, "PTS %02d  x%X\n\nStreamId=x%04X",  CandidatePTS, CandidatePTS, getbit_MPA_Track);
                     MessageBox(hWnd, szBuffer, "Mpg2Cut2 - BUG !",
                                              MB_ICONSTOP | MB_OK);
                 }
#endif

                 PTS_Flag[1] = 'A';
                 if (CandidatePTS < Prev_PTS[getbit_MPA_Track])
                 {
                   if (iCtl_MultiAngle)
                   {
                     if (process.Action == ACTION_RIP)
                         getbit_iDropPkt_Flag = 1;
                   }
                   else
                   if (process.Action == ACTION_FWD_GOP)
                   {
                     PTS_Err_Msg(getbit_AUDIO_ID, CandidatePTS, "MPG Audio");
                   }
                   
                 }
                 if (! getbit_iDropPkt_Flag)
                     Prev_PTS[getbit_MPA_Track] = CandidatePTS;
}



  static unsigned int getbit_AC3_Track;
  int iMPA_PCM_Len1;

  float fPCMData[1152*4*2];
  int iMPA_FrameOK;

  unsigned char *RdPTR_Peek;

  static int getAudio_size;



//----------------------------------------------------

void Got_PrivateStream()
{
  int iGot_Track_Type, iLPCM_ctl, iDecodeOK_Flag;
  unsigned uBitsPerSample, uChannels, uQWord_Len, uMode, uRate;
  unsigned char *lpConvEND, *lpConvOUT;
  int i, iTmp1, iTmp3;

  iDecodeOK_Flag = 0;

  getbit_StreamID = getbit_input_code;
  process.SkipPTS = 0;

  getbit_iPkt_Len_Remain     = Get_Short();

  if (MParse.SystemStream_Flag < 0)
      getbit_iPkt_Len_Remain = RdEndPkt - RdPTR;


  getbit_PES_Gate         = Get_Byte(); //
  getbit_PES_HdrFld_Flags = Get_Byte(); // PES header field flags
  getbit_iPkt_Hdr_Len     = Get_Byte();
  getbit_iPkt_Hdr_Len_Remaining = getbit_iPkt_Hdr_Len;

  if (DBGflag)
  {
      sprintf(szBuffer,"      PS AUDIO Len=%d=x%04X  PS2Audio=%d",
                            getbit_iPkt_Len_Remain, getbit_iPkt_Len_Remain, iInPS2_Audio);
      DBGout(szBuffer);
  }

  if (getbit_PES_HdrFld_Flags >= 0x80) // Is there a PTS ?
  {
      CandidatePTS = Get_PTS(0); // Keep until we decide this is selected track

      PTS_Flag[2] = '1';

  }

  RdPTR += getbit_iPkt_Hdr_Len_Remaining;

  getbit_iPkt_Len_Remain -= (getbit_iPkt_Hdr_Len+4);

  getbit_SubStreamID = Get_Byte();
  getbit_AUDIO_ID    = getbit_SubStreamID;

  if (getbit_StreamID == PRIVATE_STREAM_1)
  {
      if (! PktStats.iPS1_Packets)
            SetDlgItemText(hStats, IDC_AUDIO_PS1, "PS1" );
      PktStats.iPS1_Packets++;
      //iAudio_Track_Type[6] = FORMAT_PS1;
  }
  else
  {
     if (! PktStats.iPS2_Packets)
           SetDlgItemText(hStats, IDC_AUDIO_PS2, "PS2" );
     PktStats.iPS2_Packets++;
     //iAudio_Track_Type[7] = FORMAT_PS2;
     getbit_AUDIO_ID = SUB_AC3; // JUST CHUCK DATA AT THE AC3 DECODER
  }

  // if (rj_Audio_Code==Audio_Dunno)
  //       rj_Audio_Code = getbit_AUDIO_ID ;  //RJTRK

  getbit_AC3_Track = 99;

  // Is it an AC3 substream ?
  if (getbit_AUDIO_ID >= SUB_AC3
  &&  getbit_AUDIO_ID < (SUB_AC3 +CHANNELS_MAX))
  {
      getbit_AC3_Track = getbit_AUDIO_ID - SUB_AC3;
      iGot_Track_Type = FORMAT_AC3;
  }
  else
  // Is it a DTS substream ?
  if (getbit_AUDIO_ID >= SUB_DTS
  &&  getbit_AUDIO_ID < (SUB_DTS +CHANNELS_MAX))
  {
      getbit_AC3_Track = getbit_AUDIO_ID - SUB_DTS +6;
      iGot_Track_Type = FORMAT_DTS;
  }
  else
  // Is it a Sub-Title substream ?
  if (getbit_AUDIO_ID >= SUB_SUBTIT
  &&  getbit_AUDIO_ID < (SUB_SUBTIT +CHANNELS_MAX))
  {
      getbit_AC3_Track = getbit_AUDIO_ID - SUB_SUBTIT;
      iGot_Track_Type = FORMAT_SUBTIT;
  }
  else
  // Is it a Mpeg Audio on a private Stream ?
  if (getbit_AUDIO_ID >= SUB_DDPLUS
  &&  getbit_AUDIO_ID < (SUB_DDPLUS +CHANNELS_MAX))
  {
      getbit_AC3_Track = getbit_AUDIO_ID - SUB_DDPLUS;
      iGot_Track_Type = FORMAT_DDPLUS;
  }
  else
  // Is it a PCM substream ?
  if (getbit_AUDIO_ID >= SUB_PCM
  &&  getbit_AUDIO_ID < (SUB_PCM +CHANNELS_MAX-4))
  {
      getbit_AC3_Track = getbit_AUDIO_ID - SUB_PCM +4;
      iGot_Track_Type = FORMAT_PCM;
      iTmp1 = Get_Byte(); // No of Frames starting in this packet (does not include tail from previous packet, but does include last partial frame in this packet)
      iPS_Frame_Offset = Get_Short(); // Offset to start of 1st frame for this PTS = first access unit pointer

      iTmp3 = Get_Byte(); // Flags:
                   //    audio emphasis on-off        1 bit
                   //    audio mute on-off            1 bit
                   //    reserved                     1 bit
                   //    audio frame number           5 bits (within Group of Audio frames).

      iLPCM_ctl = Get_Byte(); // LPCM Attributes:
                   // quantization word length code   2 bits  0 = 16, 1 = 20, 2 = 24, 3 = reserved
                   // audio sampling frequency        2 bits  (48khz = 0, 96khz = 1)
                   // reserved                        1 bit
                   // number of audio channels - 1    3 bit  (e.g. stereo = 1)

      uQWord_Len = iLPCM_ctl >>6;
      uBitsPerSample = (uQWord_Len + 4) * 4;

      if ((iLPCM_ctl & 0x30) == 0x10)
      {
          PCM_SamplingRate = 96000;
      }
      else
      {
          PCM_SamplingRate = 48000;
      }
      ac3_Ctl[getbit_AC3_Track].rate = PCM_SamplingRate / 1000;

      uChannels      = (iLPCM_ctl & 0x03) + 1;
      ac3_Ctl[getbit_AC3_Track].mode = uChannels;

      iTmp1 = Get_Byte(); // Dynamic Range control (0x80 if off)
                          //      Dynamic Range X     3 bits
                          //      Dynamic Range Y     5 bits
                          // linear gain = 2^(4-(X+(Y/30)))
                          //  in dB gain = 24.082 - 6.0206 X - 0.2007 Y

      getbit_iPkt_Len_Remain -= 6;

  }
  else
  {
      getbit_AC3_Track = getbit_AUDIO_ID;
      iGot_Track_Type  = FORMAT_UNK;
  }


  // Is it a playable format ?
  if (getbit_AC3_Track < CHANNELS_MAX
  &&  iGot_Track_Type  < FORMAT_SUBTIT)
  {
      // Auto detect Audio track
      if (iAudio_Track_SEL == TRACK_AUTO
      &&  iGot_Track_Type  < FORMAT_DDPLUS
      &&  (iWant_Aud_Format == iGot_Track_Type ||  ! iWant_Aud_Format)
      )
          iAudio_Track_SEL =  getbit_AC3_Track;

      Prev_PTS_IX = getbit_AC3_Track  + 8;
      if (getbit_PES_HdrFld_Flags >= 0x80) // PTS present ?
      {
          if (CandidatePTS < Prev_PTS[Prev_PTS_IX])
          {
              if (iCtl_MultiAngle)
              {
                 if (process.Action == ACTION_RIP)
                     getbit_iDropPkt_Flag = 1;
              }
              else
              if (process.Action == ACTION_FWD_GOP)
              {
                  PTS_Err_Msg(Prev_PTS_IX, CandidatePTS, "PS Audio");
              }
          }

          if (getbit_iDropPkt_Flag)
            return;
          else
              Prev_PTS[Prev_PTS_IX] = CandidatePTS;
      }

      if (getbit_AC3_Track == iAudio_Track_SEL)  // is it the one to play?
      {
         if (getbit_PES_HdrFld_Flags >= 0x80) // PTS present ?
         {
             process.AudioPTS = CandidatePTS;

             if (process.Delay_Calc_Flag)
                 GetDelay();
         }

         process.PES_Audio_CRC_Flag = Mpeg_PES_Byte1 & 0x02;
         if (process.iAudio_InterFrames)
         {
                  process.iAudio_Interleave = process.iAudio_InterFrames;
                  process.iAudio_InterFrames = 0;
         }
      }

#ifdef DBG_RJ
          if (DBGflag  && CandidatePTS > 0xFF000000)
          {
                sprintf(szBuffer, "PTS %02d  x%X\n\nStreamId=x%04X\n\nSubStream=x%04x",  CandidatePTS, CandidatePTS, getbit_StreamID, getbit_SubStreamID);
                MessageBox(hWnd, szBuffer, "Mpg2Cut2 - BUG !",
                                            MB_ICONSTOP | MB_OK);
          }
#endif

      // LOCATE TO FIRST SYNCWORD

      // Skip control info at start of packet
      if (iGot_Track_Type == FORMAT_AC3
      ||  iGot_Track_Type == FORMAT_DTS      // DD-DTS  decoding is experimental
      ||  iGot_Track_Type == FORMAT_DDPLUS)  // DD-PLUS decoding is experimental
      {
         RdPTR += 3;  getbit_iPkt_Len_Remain -= 3; // Skip syncword count and first offset pointer
         // TODO: Theoretically we could use the offset pointer to avoid scanning later
         MPEG_PTR_BUFF_CHK                  // skip forward, reading more if needed
      }


      // TODO:

      // IF   this code was changed to avoid using Get_Byte() / Get_Short()
      // THEN it could peek ahead at the AC3 header
      // TO   check for format changes


      // getbit_AC3_1stTime = 0; 

      // Is this the first time we've hit this track ?
      if ( (!ac3_Ctl[getbit_AC3_Track].rip    // &&  MParse.Rip_Flag
            &&  !iAudio_Track_Type[getbit_AC3_Track]) 
      // OR track type has changed
      //||  iAudio_Track_Type[getbit_AC3_Track] != iGot_Track_Type
      )
      {
         //getbit_AC3_1stTime = 1;
         iAudio_Track_Type[getbit_AC3_Track] = iGot_Track_Type;
         process.iAudio_PS1_Found = 1;

         if (iGot_Track_Type == FORMAT_PCM)
         {
            RdPTR           += iPS_Frame_Offset; // Skip to start of audio frame
            getbit_iPkt_Len_Remain -= iPS_Frame_Offset;
            MPEG_PTR_BUFF_CHK
         }
         else
         if (iGot_Track_Type == FORMAT_AC3
         ||  iGot_Track_Type == FORMAT_DTS      // DD-DTS  is only a guess
         ||  iGot_Track_Type == FORMAT_DDPLUS)  // DD-PLUS is only a guess
         {
             getbit_input_code = Get_Byte();
             getbit_input_code = (getbit_input_code & 0xff)<<8 | Get_Byte();
             i = 0;
             while (getbit_input_code != 0xb77  // AC3 sync sentinel ??
               &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL   // RJ ALLOW FOR BAD DATA
               && ! MParse.Stop_Flag )
             {
                 getbit_input_code = (getbit_input_code & 0xff)<<8 | Get_Byte();
                 i++;
             }

             iPS_Frame_Offset = i;
             if (MParse.ShowStats_Flag)
             {
                 sprintf(szBuffer, "%d", iPS_Frame_Offset);
                 SetDlgItemText(hStats, IDC_AC3_OFFSET, szBuffer);
             }

             Get_Short();
             uRate     = (Get_Byte()>>1) & 0x1f;
             Get_Byte();
             uMode     = (Get_Byte()>>5) & 0x07;

             if (ac3_Ctl[getbit_AC3_Track].rate != uRate
             ||  ac3_Ctl[getbit_AC3_Track].mode != uMode)
             {
                 ac3_Ctl[getbit_AC3_Track].rate  = uRate;
                 ac3_Ctl[getbit_AC3_Track].mode  = uMode;

                 if (getbit_MPA_Track == iAudio_Track_SEL
                 &&  byAC3_Init)
                 {
                    byAC3_Init = 0;
                 }
             }

             RdPTR -= 7; getbit_iPkt_Len_Remain -= i;

             uBitsPerSample  = 16;
             uChannels       = 2; // We always output stereo
         } // end-if AC3


         if (iPlayAudio // MParse.Rip_Flag
         &&  (getbit_AC3_Track == iAudio_Track_SEL)  // is it the one to play?
         // &&  (iWant_Aud_Format == iGot_Track_Type ||  ! iWant_Aud_Format)  // DONE ABOVE
               /* && (AVI_Flag || D2V_Flag  || Decision_Flag)*/
            )
         {
                 /* CONVERSION TO WAV PCM NO LONGER SUPPORTED
                 sprintf(szBuffer, "%s AC3 T%02d %sch %dKbps %s.wav", szOutput, iAudio_Track_SEL+1,

                 AC3ModeDash[ac3_Ctl[getbit_AC3_Track].mode], AC3Rate[ac3_Ctl[getbit_AC3_Track].rate], FTType[SRC_Flag]);
                 strcpy(pcm.filename, szBuffer);
                 pcm.file = fopen(szBuffer, "wb");
                 fwrite(WAVHeader, sizeof(WAVHeader), 1, pcm.file);
                 */

                pcm.delay = ((CandidatePTS-process.VideoPTS)/45) * 192;

                /*
                if (SRC_Flag)
                {
                      DownWAV(pcm.file);
                      InitialSRC();
                }
                */

                 if (pcm.delay > 0)
                 {
                      /*
                      if (SRC_Flag)
                          pcm.delay = ((int)(0.91875*pcm.delay)>>2)<<2;
                      for (i=0; i<pcm.delay; i++)
                        fputc(0, pcm.file);
                      */
                      pcm.size += pcm.delay;
                      pcm.delay = 0;
                  }

                  if (iPlayAudio)
                  {
                    if ((iGot_Track_Type == FORMAT_AC3
                       ||iGot_Track_Type == FORMAT_DTS      // DD-DTS  is only experimental
                       ||iGot_Track_Type == FORMAT_DDPLUS  // DD-PLUS cannot really be decoded
                        )
                    &&  !byAC3_Init)
                    {
                         InitialAC3();
                         iDecodeOK_Flag = byAC3_Init;
                         if (iAudio_Boost == 32)
                         {
                           if (uMode < 3 && iGot_Track_Type == FORMAT_AC3)
                             iAudio_Boost = iAudio_Boost * 2;
                           else
                             iAudio_Boost = iAudio_Boost * 4;
                         }
                    }

                    //else
                    //if (iGot_Track_Type == FORMAT_PCM)
                    //{
                    //     ????;
                    //}

                  }
                  //else
                  //  ac3_Ctl[getbit_AC3_Track].rip = 1;

         } // END-IF Selected format for playing ?
         //else
          ac3_Ctl[getbit_AC3_Track].rip = 1;

      } // END-IF 1st Time Hit This Track

      // Play this track ?
      if (iPlayAudio)
      {
         if (getbit_AC3_Track == iAudio_Track_SEL)  // is it the one to play?
         {
            if (ac3_Ctl[getbit_AC3_Track].rip)  // Has this track been setup ?
            {
               if (iGot_Track_Type == FORMAT_PCM)
               {
                  iDecodeOK_Flag = 1;
                  lpConvEND = RdPTR + getbit_iPkt_Len_Remain;
                  lpConvOUT = &AC3Dec_Buffer[PlayCtl.iPCM_Remainder];

                  iTmp1 = getbit_iPkt_Len_Remain+PlayCtl.iPCM_Remainder;
                  getAudio_size = iTmp1 & 0xFFFFC;
                  PlayCtl.iPCM_Remainder = iTmp1 - getAudio_size;

                  WAV_Byte_Swap(uQWord_Len, RdPTR, lpConvOUT, getbit_iPkt_Len_Remain);

               }
               else
               if (byAC3_Init)
               {
                  CONV_A53_PKT_PCM

                  if (AC3_Err_Txt[0])
                  {
                      strcpy(szAudio_Status, AC3_Err_Txt);
                      if (MParse.ShowStats_Flag)
                          Stats_Audio_Boost();
                      AC3_Err_Txt[0] = 0;
                  }
                  PCM_SamplingRate = A53_sampling_rate;
                  iDecodeOK_Flag = byAC3_Init;
               }

               if (!PlayCtl.iAC3_Attempted && iDecodeOK_Flag)
               {
                   PlayCtl.iAC3_Attempted = 1;
                   if (!iWAV_Init)
                         WAV_Set_WIN_Parms (INVALID_FILEDESC,
                                           PCM_SamplingRate,
                                           uBitsPerSample,  uChannels);
               }

               if (-pcm.delay >  getAudio_size)
                    pcm.delay += getAudio_size;
               else
               {
                 /*
                 if (SRC_Flag)
                   Wavefs44(pcm.file, getAudio_size+pcm.delay, AC3Dec_Buffer-pcm.delay);
                 else
                   fwrite(AC3Dec_Buffer-pcm.delay, getAudio_size+pcm.delay, 1, pcm.file);
                 */

                 if ((iDecodeOK_Flag // && iGot_Track_Type == FORMAT_AC3
                                 //|| iGot_Track_Type == FORMAT_PCM
                                 )
                 && iWAV_Init && iPlayAudio  && MParse.FastPlay_Flag <= MAX_WARP )
                 {
                     iMPA_PCM_Len1 = getAudio_size + pcm.delay;
                     WAV_Packet_Warp( (AC3Dec_Buffer-pcm.delay),
                                       iMPA_PCM_Len1);


                    if (iGot_Track_Type == FORMAT_PCM) // Shuffle remainder to start of buffer for next time
                    {
                        *(DWORD*)(&AC3Dec_Buffer) = *(DWORD*)(lpConvEND);
                    }

                 }
                 pcm.size += getAudio_size+pcm.delay;
                 pcm.delay = 0;
               }

            } // ENDIF Track set up ?

         } // ENDIF Play this track ?

      }  // ENDIF iPlayAudio

  } // ENDIF AC3 SUB-STREAM-ID

  else
  if ((getbit_AUDIO_ID & 0xF0) == SUB_SUBTIT)
  {
       PktStats.iSubTit_Packets++;
  } // ENDIF Sub-Title SUB-STREAM-ID

  else
  if (getbit_StreamID == PRIVATE_STREAM_2)
  {
      if (RdPTR < (RdEOB_8))
      {
          sprintf(szBuffer, "%x.%08x %d.%d",
                  getbit_SubStreamID, *(int*)(RdPTR),
                              getbit_iPkt_Hdr_Len_Remaining, getbit_iPkt_Len_Remain);
          SetDlgItemText(hStats, IDC_PS2_STATUS, szBuffer );
      }

      if (++getbit_VOBCELL_Count == 2)
      {
           RdPTR  += 17;
           getbit_VOB_ID  = /*(unsigned short)*/Get_Short();  //RJ CAREFUL OF CAST
           getbit_CELL_ID = /*(unsigned short)*/Get_Short();  //      "

           //RdPTR  += getbit_iPkt_Len_Remain - 29;
           getbit_iPkt_Len_Remain -=21;


           if (process.Action == ACTION_RIP
           &&  iWant_VOB_ID < 0)
               iWant_VOB_ID = getbit_VOB_ID;

           sprintf(szBuffer, "Vob%d Cell%d", getbit_VOB_ID, getbit_CELL_ID);;
           SetDlgItemText(hStats, IDC_VOB_ID, szBuffer);
      }
  } // END-IF PS2 NON-AC3 substream
}



//----------------------------------------------------------
void Got_MPA_Hdr()
{
  int iRC;

  uMPA_ID_Creature = 4-(RdPTR[1]>>3)&3;
  uMPA_Layer_Ix    = 3-(RdPTR[1]>>1)&3;
  uMPA_SampFreq_Ix =   (RdPTR[2]>>2)&3;
  uMPA_Padding     =   (RdPTR[2]>>1)&1;
  uMPA_kBitRate_Ix =   (RdPTR[2]>>4)&15;
  uMPA_ChMode_Ix   =   (RdPTR[3]>>6)&3;

  uMPA_Layer     = uMPA_Layer_Ix + 1;
  uMPA_SAMPLE_HZ = MPA_SAMPLE_HZ[uMPA_ID_Creature][uMPA_SampFreq_Ix];
  uMPA_kBitRate  = MPA_KBIT_RATE[uMPA_Layer_Ix][uMPA_kBitRate_Ix];

  sprintf( mpa_Ctl[getbit_MPA_Track].desc, "mp%d %dk %s",
             uMPA_Layer,
             uMPA_kBitRate, //(uMPA_SAMPLE_HZ/1000),
             MPG_CH_MODE_ABBR[uMPA_ChMode_Ix] );

  uSlotBytes     = MPA_SLOT_BYTES[uMPA_Layer_Ix];
  iMPA_FrameLen  = uMPA_kBitRate * 1000 
                 * uSlotBytes
                 / uMPA_SAMPLE_HZ;
  if (uMPA_Padding)
     iMPA_FrameLen += uSlotBytes;

  if (MParse.ShowStats_Flag
  && iMPA_FrameLen != StatsPrev.iFrameLen)
  {
       sprintf(szBuffer, "%d", iMPA_FrameLen);
       SetDlgItemText(hStats, IDC_AC3_OFFSET, szBuffer);
       StatsPrev.iFrameLen = iMPA_FrameLen;
  }

  if (iMPA_FrameLen < 128) // Check for cruddy control data
      iMPA_FrameLen = 128;

  /*
  // Validate frame structure if requested
  if (uMPA_Layer < 3) // dunno about mp3
  {
      iMPA_FrameOK = 0;
      RdPTR_Peek = RdPTR + iMPA_FrameLen;
      if (RdPTR_Peek < RdEndPkt
      &&  RdPTR_Peek < RdEOB)
          if (RdPTR_Peek[0] == 0xFF) // Points to Syncword ?
             iMPA_FrameOK = 1;
  }
  else */
    iMPA_FrameOK = 1;

  if (iMPA_FrameOK 
  &&  uMPA_Layer > 1 && uMPA_Layer < 4) // A format we can decode ?
  {
     if (iAudio_Track_SEL == getbit_MPA_Track)   /*|| !MPA_Flag*/
     {
        process.PES_Audio_CRC_Flag = Mpeg_PES_Byte1 & 0x02;

        if (MParse.Rip_Flag  &&  iPlayAudio)
        {
           if (! iMPAdec_Init)
           {
              if (iMPALib_Status < 0)
                  MPALib_Init(NULL);

              if(!iMPAdec_Init  &&  byMPALib_OK)
                   MPAdec.mlInit(&MPAdec.mp, (1<<15)-1);

              MPAdec.dwFree=1152*4*2;
              lpTmpMPA = (char*)&AC3Dec_Buffer;
           }

           if (byMPALib_OK && !iWAV_Init)
           {
              iRC = WAV_Set_WIN_Parms (INVALID_FILEDESC,
                                       uMPA_SAMPLE_HZ,
                               /*byTByPerSample*/2<<3,  // Hard coded 16bit samples
                              (uMPA_ChMode_Ix==3?1:2)); // #3=Mono, others=Stereo
              if (iRC == 0 && iPlayAudio)
              {
                 iWAV_Init = 1;
                 iMPAdec_Init=1;
                 mpa_Ctl[getbit_MPA_Track].rip = 1;
                 if (process.Delay_Sign[0] == '-')
                 {
                     PktStats.iAudDelayBytes = (process.Delay_ms * uMPA_SAMPLE_HZ)
                                             / 500 ;
                     if (uMPA_ChMode_Ix != 3)
                       PktStats.iAudDelayBytes *= 2;
                 }
              }
           }
        }
     } // ENDIF  Selected Track ?
     else
       mpa_Ctl[getbit_MPA_Track].rip = 1;

  } // ENDIF  Frame looks OK

}



//----------------------

void Got_MPA_PayLoad()
{

         // Is this track still awaiting setup ?
         if ( ! mpa_Ctl[getbit_MPA_Track].rip)
         {
            // Scan for an Mpeg Audio SyncWord
            getbit_input_code  = Get_Byte();
            getbit_input_code  = (getbit_input_code /* & 0xFF*/ )<<8;
            getbit_input_code |= Get_Byte();

            getbit_iPkt_Len_Remain -= 2;  
            //i = 0;
            while (getbit_input_code < 0xFFF8   // Syncword(12bits) + mpeg_ind(1bit)
               &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL   // RJ ALLOW FOR BAD DATA
               && ! MParse.Stop_Flag
               && getbit_iPkt_Len_Remain)
            {
                  getbit_input_code  = (getbit_input_code & 0xFF);
                  getbit_input_code  =  getbit_input_code   <<8;
                  getbit_input_code |= Get_Byte();
                  getbit_iPkt_Len_Remain--;
                  //i++;
            }

               /*sprintf(szBuffer, "%s MPA T%02d DELAY %dms.mpa_Ctl[", szOutput, getbit_MPA_Track+1, (process.AudioPTS-process.VideoPTS)/90);
               /mpa_Ctl[getbit_MPA_Track].file = fopen(szBuffer, "wb");*/

            // Back up a little
            RdPTR -= 2; 
            getbit_iPkt_Len_Remain += 2; 

            if (getbit_iPkt_Len_Remain
            && (RdPTR[0]==255) &&  (RdPTR[1] & 0xF8) == 0xF8) //  >>5==7))  // // Syncword(12bits) + mpeg_ind(1bit)
                     // Recheck audio syncword in case packet boundary crossed
            {
              Got_MPA_Hdr();
            } // Got an Audio SyncByte ?

         } // ENDIF First Time this track

         // else
         if (mpa_Ctl[getbit_MPA_Track].rip
         && (iAudio_Track_SEL == getbit_MPA_Track)
         && (iWAV_Init && iMPAdec_Init && iPlayAudio && byMPALib_OK))
         {

              while (getbit_iPkt_Len_Remain > 0
                &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL
                && ! MParse.Stop_Flag )
              {
                if (getbit_iPkt_Len_Remain+RdPTR > RdEOB)
                {
                    MPAdec.nRet =MPAdec.mlDecode(&MPAdec.mp,
                                            (char*)RdPTR, RdEOB-RdPTR,
                                            (char*)fPCMData,MPAdec.dwFree,
                                             &MPAdec.nSize);
                    while (MPAdec.nRet == ML_OK
                      &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL
                      && ! MParse.Stop_Flag )
                    {                                 
                      if (MPAdec.nSize && iPlayAudio && MParse.FastPlay_Flag <= MAX_WARP) 
                      {                               
                        float2int(fPCMData,(BYTE*)fPCMData,
                                                MPAdec.nSize/sizeof(float));

                        /* 
                        if (uMPA_ChMode_Ix == 3) // Mono Experiment
                        {
                          WAV_Byte_Swap(0, (BYTE*)fPCMData, (BYTE*)fPCMData, 
                                           MPAdec.nSize/2);
                        }
                        */
                        iMPA_PCM_Len1 = MPAdec.nSize/2;
                        if (PktStats.iAudDelayBytes > 0)
                        {
                          if (iMPA_PCM_Len1 <= PktStats.iAudDelayBytes) 
                          {
                              iMPA_PCM_Len1 -= PktStats.iAudDelayBytes;
                              PktStats.iAudDelayBytes = 0;
                          }
                          else
                          {
                              PktStats.iAudDelayBytes -= iMPA_PCM_Len1;
                              iMPA_PCM_Len1 = 0;
                          }
                        }
                        
                        if (iMPA_PCM_Len1 > 0)
                            WAV_Packet_Warp((BYTE*)fPCMData, iMPA_PCM_Len1);
                      }
                      MPAdec.nRet = MPAdec.mlDecode(&MPAdec.mp, NULL, 0,
                            (char*)fPCMData, MPAdec.dwFree,&MPAdec.nSize);
                    }
                    getbit_iPkt_Len_Remain -= RdEOB-RdPTR;
                    Mpeg_READ();
                    RdPTR = RdBFR;
                }
                else
                {
                   MPAdec.nRet =MPAdec.mlDecode(&MPAdec.mp,
                                         (char*)RdPTR,
                                               getbit_iPkt_Len_Remain,
                                        (char*)fPCMData,MPAdec.dwFree,
                                              &MPAdec.nSize);
                    while(MPAdec.nRet  == ML_OK
                     &&   MParse.Fault_Flag < CRITICAL_ERROR_LEVEL
                     && ! MParse.Stop_Flag )
                    {
                      if (MPAdec.nSize && iPlayAudio && MParse.FastPlay_Flag <= MAX_WARP )
                      {
                         float2int(fPCMData,(BYTE*)fPCMData,
                                             MPAdec.nSize/sizeof(float));
                         iMPA_PCM_Len1 = MPAdec.nSize/2;
                         if (PktStats.iAudDelayBytes > 0)
                         {
                           if (iMPA_PCM_Len1 <= PktStats.iAudDelayBytes) 
                           {
                              iMPA_PCM_Len1 -= PktStats.iAudDelayBytes;
                              PktStats.iAudDelayBytes = 0;
                           }
                           else
                           {
                              PktStats.iAudDelayBytes -= iMPA_PCM_Len1;
                              iMPA_PCM_Len1 = 0;
                           }
                         }

                        
                         if (iMPA_PCM_Len1 > 0)
                             WAV_Packet_Warp((BYTE*)fPCMData, iMPA_PCM_Len1);

                      }

                      MPAdec.nRet = MPAdec.mlDecode(&MPAdec.mp,NULL,0,
                                             (char*)fPCMData,
                                           MPAdec.dwFree,&MPAdec.nSize);
                    } // endwhile OK

                    RdPTR += getbit_iPkt_Len_Remain;
                    getbit_iPkt_Len_Remain = 0;
                }  // END ELSE
              } // END WHILE PktLenRemaining

         } // ENDIF to be played

}


//----------------------

void Got_MPA_Pkt()
{
  //getbit_AUDIO_ID  = getbit_input_code;

  getbit_MPA_Track = getbit_input_code - AUDIO_ELEMENTARY_STREAM_0;
  process.SkipPTS = 0;
  PktStats.iMPA_Packets++;

  getbit_iPkt_Len_Remain = Get_Short();

  // Transport stream PES length does not apply - calc from TS packet
  if (MParse.SystemStream_Flag < 0)
      getbit_iPkt_Len_Remain = RdEndPkt - RdPTR;
  else
  {
      RdEndPkt = RdPTR + getbit_iPkt_Len_Remain; RdEndPkt_4 = RdEndPkt-4; RdEndPkt_8 = RdEndPkt-8;
  }

  Mpeg_PES_Byte1   = Get_Byte(); 
  getbit_iPkt_Len_Remain--;

  Mpeg_PES_Version = Mpeg_PES_Byte1>>6;
  getbit_iDropPkt_Flag = 1;

  if ((iWant_Aud_Format == FORMAT_MPA || !iWant_Aud_Format)/* && (AVI_Flag || D2V_Flag)*/)
  {
      // Auto detect Audio track
      if (iAudio_Track_SEL == TRACK_AUTO)
          iAudio_Track_SEL =  getbit_MPA_Track ;

      //if (Mpeg_PES_Version == 2     // Mpeg-2 format ? //if ((getbit_input_code & 0xc0) == 0x80)
      //||  iPES_Mpeg_Any)
      {
        getbit_iDropPkt_Flag = 0;
        iAudio_Track_Type[getbit_MPA_Track] = FORMAT_MPA;
        process.iAudio_MPA_Found = 1;

        if (getbit_MPA_Track == iAudio_Track_SEL)  // is it the one to play?
        {
            if (process.iAudio_InterFrames)
            {
                process.iAudio_Interleave = process.iAudio_InterFrames;
                process.iAudio_InterFrames = 0;
            }
        }

        
        if (Mpeg_PES_Version != 2)  // Mpeg-1 - NO HEADER processing - EXPERIMENTAL
        {
            Mpeg1_PesHdr();
            getbit_iPkt_Len_Remain -= getbit_iPkt_Hdr_Len_Remaining;
        }
        else
        {
            getbit_PES_HdrFld_Flags = Get_Byte();   // Field Flags
            getbit_iPkt_Hdr_Len = Get_Byte();              // PES_header_data_length
            getbit_iPkt_Hdr_Len_Remaining = getbit_iPkt_Hdr_Len;

            if (getbit_PES_HdrFld_Flags>=0x80) // PTS present ?
            {
               CandidatePTS = Get_PTS(0);
               PTS_Audio_Analysis();
            }

            getbit_iPkt_Len_Remain -= (getbit_iPkt_Hdr_Len+2);
        }

        RdPTR += getbit_iPkt_Hdr_Len_Remaining;  // Discard rest of header -boring stuff

        MPEG_PTR_BUFF_CHK
      }

      if (! getbit_iDropPkt_Flag)
      {
         Got_MPA_PayLoad();
      } // END - Not to be dropped ?

  } // END - Interested in MPA format ?

}




